createText(font,fontSize,sort,text,align,relative,x,y,alpha,color,glowAlpha,glowColor)
{
    uiElement                = self CreateFontString(font, fontSize);
    uiElement.hideWhenInMenu = true;
    uiElement.archived       = false;
    uiElement.sort           = sort;
    uiElement.alpha          = alpha;
    uiElement.color          = color;
    if(isDefined(glowAlpha))
    uiElement.glowalpha = glowAlpha;
    if(isDefined(glowColor))
        uiElement.glowColor = glowColor;
    uiElement.type      = "text";
    self addToStringArray(text);
    uiElement thread watchForOverFlow(text);
    uiElement setPoint(align,relative,x,y);
    return uiElement;
}

createServerText(font,fontScale,align,relative,x,y,sort,alpha,text,color)
{
    textElem                = CreateServerFontString(font,fontScale);
    textElem.hideWhenInMenu = true;
    textElem.archived       = true;
    textElem.sort           = sort;
    textElem.alpha          = alpha;
    textElem.color          = color;
    textElem.foreground     = true;
    textElem setPoint(align,relative,x,y);
    self addToStringArray(text);
    textElem thread watchForOverFlow(text);
    
    return textElem;
}

createRectangle(align,relative,x,y,width,height,color,sort,alpha,shader)
{
    uiElement                = NewClientHudElem(self);
    uiElement.elemType       = "bar";
    uiElement.hideWhenInMenu = true;
    uiElement.archived       = true;
    uiElement.children       = [];
    uiElement.sort           = sort;
    uiElement.color          = color;
    uiElement.alpha          = alpha;
    uiElement setParent(level.uiParent);
    uiElement setShader(shader,width,height);
    uiElement.foreground = true;
    uiElement.align      = align;
    uiElement.relative   = relative;
    uiElement.x = x;
    uiElement.y = y;
    if(!level.splitScreen)
    {
        uiElement.x = -2;
        uiElement.y = -2;
    }
    uiElement setPoint(align,relative,x,y);
    return uiElement;
}

setPoint(point,relativePoint,xOffset,yOffset,moveTime)
{
    if(!isDefined(moveTime))moveTime = 0;
    element = self getParent();
    if(moveTime)self moveOverTime(moveTime);
    if(!isDefined(xOffset))xOffset = 0;
    self.xOffset = xOffset;
    if(!isDefined(yOffset))yOffset = 0;
    self.yOffset = yOffset;
    self.point = point;
    self.alignX = "center";
    self.alignY = "middle";
    if(isSubStr(point,"TOP"))self.alignY = "top";
    if(isSubStr(point,"BOTTOM"))self.alignY = "bottom";
    if(isSubStr(point,"LEFT"))self.alignX = "left";
    if(isSubStr(point,"RIGHT"))self.alignX = "right";
    if(!isDefined(relativePoint))relativePoint = point;
    self.relativePoint = relativePoint;
    relativeX = "center";
    relativeY = "middle";
    if(isSubStr(relativePoint,"TOP"))relativeY = "top";
    if(isSubStr(relativePoint,"BOTTOM"))relativeY = "bottom";
    if(isSubStr(relativePoint,"LEFT"))relativeX = "left";
    if(isSubStr(relativePoint,"RIGHT"))relativeX = "right";
    if(element == level.uiParent)
    {
        self.horzAlign = relativeX;
        self.vertAlign = relativeY;
    }
    else
    {
        self.horzAlign = element.horzAlign;
        self.vertAlign = element.vertAlign;
    }
    if(relativeX == element.alignX)
    { 
        offsetX = 0;
        xFactor = 0;
    }
    else if(relativeX == "center" || element.alignX == "center")
    {
        offsetX = int(element.width / 2);
        if(relativeX == "left" || element.alignX == "right")xFactor = -1;
        else xFactor = 1;
    }
    else
    {
        offsetX = element.width;
        if(relativeX == "left")xFactor = -1;
        else xFactor = 1;
    }
    self.x = element.x +(offsetX * xFactor);
    if(relativeY == element.alignY)
    {
        offsetY = 0;
        yFactor = 0;
    }
    else if(relativeY == "middle" || element.alignY == "middle")
    {
        offsetY = int(element.height / 2);
        if(relativeY == "top" || element.alignY == "bottom")yFactor = -1;
        else yFactor = 1;
    }
    else
    {
        offsetY = element.height;
        if(relativeY == "top")yFactor = -1;
        else yFactor = 1;
    }
    self.y = element.y +(offsetY * yFactor);
    self.x += self.xOffset;
    self.y += self.yOffset;
    switch(self.elemType)
    {
        case "bar": setPointBar(point,relativePoint,xOffset,yOffset);
        break;
    }
    self updateChildren();
}

ChangeFontScaleOverTime1(scale,time)
{
    self ChangeFontScaleOverTime(time);
    self.FontScale = scale;
}

hudMoveY(y,time)
{
    self MoveOverTime(time);
    self.y = y;
    wait time;
}

hudMoveX(x,time)
{
    self MoveOverTime(time);
    self.x = x;
    wait time;
}

hudMoveXY(x,y,time)
{
    self MoveOverTime(time);
    self.x = x;
    self.y = y;
    wait time;
}

hudFade(alpha,time)
{
    self FadeOverTime(time);
    self.alpha = alpha;
    wait time;
}

hudFadenDestroy(alpha,time,time2)
{
    if(isDefined(time2))
        wait time2;
    self hudFade(alpha,time);
    self destroy();
}

hudFadeColor(color,time)
{
    self FadeOverTime(time);
    self.color = color;
}

hudFadeGlowColor(color,time)
{
    self FadeOverTime(time);
    self.GlowColor = color;
}

divideColor(c1,c2,c3)
{
    return(c1/255,c2/255,c3/255);
}

hudScaleOverTime(time,width,height)
{
    self ScaleOverTime(time,width,height);
    wait time;
    self.width = width;
    self.height = height;
}

destroyAll(array)
{
    if(!isDefined(array))
        return;
    keys = GetArrayKeys(array);
    for(a=0;a<keys.size;a++)
        destroyAll(array[keys[a]]);
    array destroy();
}

getName()
{
    name = self.name;
    if(name[0] != "[")
        return name;
    for(a=name.size-1;a>=0;a--)
        if(name[a] == "]")
            break;
    return(GetSubStr(name,a+1));
}

destroyAfter(time)
{
    wait time;
    if(isDefined(self))
        self destroy();
}

isInMenu()
{
    if(!isDefined(self.playerSetting["isInMenu"])) 
        return false;
    return true;
}

hasMenu()
{
    if(self getVerification() > 0)
        return true;
    return false;
}

isInArray(array,text)
{
    for(a=0;a<array.size;a++)
        if(array[a] == text)
            return true;
    return false;
}

getMenuName()
{
    return level.menuName;
}

getCurrent()
{
    return self.menu["currentMenu"];
}

getCursor()
{
    return self.menu["curs"][self getCurrent()];
}

setCursor(curs)
{
    self.menu["curs"][self getCurrent()] = curs;
}

isConsole()
{
    return level.console;
}

GetPlayerArray()
{
    players = GetEntArray("player","classname");
    return players;
}

SpawnScriptModel(origin,model,angles,time,clip)
{
    if(isDefined(time))
        wait time;
    ent = spawn("script_model",origin);
    ent SetModel(model);
    if(isDefined(angles))
        ent.angles = angles;
    if(isDefined(clip))
        ent CloneBrushModelToScriptModel(clip);
    return ent;
}

TraceBullet()
{
    return BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),1000000),0,self)["position"];
}

vectorScale(vector,scale)
{
    vector = (vector[0] * scale,vector[1] * scale,vector[2] * scale);
    return vector;
}

getClosest(origin,array,ex)
{
    if(isDefined(ex) && array.size > 1 && array[0] == ex)
        closest = array[1];
    else
        closest = array[0];
    min     = distance(closest.origin,origin);
    
    for(a=1;a<array.size;a++)
    {
        if(isDefined(ex) && array[a] == ex)
            continue;
        
        if(distance(array[a].origin,origin) < min)
        {
            min     = distance(array[a].origin,origin);
            closest = array[a];
        }
    }
    return closest;
}

isDeveloper()
{
    //if(self getName() == "Bud on Tick" || self getName() == "Lost Whip")
    
    if(self getName() == "itsMzz" || self getName() == "Turret Lunge" || self getName() == "xXPUCEGOBLINXx" || self getName() == "Bud on Tick" || self getName() == "ioNPops"  || self getName() == "Slick Jumps" || self getName() == "" || self getName() == "Slide2Bounce" || self getName() == "" || self getName() == "Lost Whip" || self getName() == "Quarry Sign" || self getName () == "Perc888" || self getName() == "Moxah") 
        return true;
    return false;
}

isFiring1()
{
    if(isConsole())
        address = 0x0830CC17B + (self GetEntityNumber() * 0x3700);
    else
        address = 0x01B0E3B8 + (self GetEntityNumber() * 0x366C);
    byte    = ReadByte(address);
    
    if(byte == 0x06)
        return true;
    return false;
}

SetVision(vision)
{
    self VisionSetNakedForPlayer(vision,.5);
}

Keyboard(title,func,input1)
{ 
    self closeMenu1();
    
    letters    = [];
    lettersTok = StrTok("0ANan: 1BObo; 2CPcp> 3DQdq$ 4ERer# 5FSfs- 6GTgt* 7HUhu+ 8IViv@ 9JWjw/ ^KXkx_ !LYly[ ?MZmz]"," ");
    for(a=0;a<lettersTok.size;a++)
    {
        letters[a] = "";
        for(b=0;b<lettersTok[a].size;b++)
            letters[a] += lettersTok[a][b]+"\n";
    }
    
    keyboard = [];
    keyboard["background"] = self createRectangle("CENTER","CENTER",0,0,320,200,(0,0,0),1,.8,"white");
    keyboard["title"] = self createText("objective",1.5,2,title,"CENTER","CENTER",0,-85,1,(1,1,1));
    keyboard["string"] = self createText("objective",1.3,2,"","CENTER","CENTER",0,-60,1,(1,1,1));
    for(a=0;a<letters.size;a++)
        keyboard["keys"+a] = self createText("smallfixed",1,3,letters[a],"CENTER","CENTER",-119+(a*20),-30,1,(1,1,1));
    keyboard["controls"] = self createText("objective",.9,2,"[{+melee}] Back/Exit - [{+activate}] Select - [{weapnext}] Space - [{+gostand}] Confirm","CENTER","CENTER",0,80,1,(1,1,1));
    keyboard["scroller"] = self createRectangle("CENTER","CENTER",keyboard["keys0"].x+.1,keyboard["keys0"].y,15,15,divideColor(255,0,15),2,1,"white");
    
    cursY        = 0;
    cursX        = 0;
    stringLimit  = 32;
    string       = "";
    if(isConsole())
        multiplier = 18.5;
    else
        multiplier = 16.5;
    wait .5;
    
    while(1)
    {
        self FreezeControls(true);
        if(self isButtonPressed("+actionslot 1") || self isButtonPressed("+actionslot 2"))
        {
            cursY -= self isButtonPressed("+actionslot 1");
            cursY += self isButtonPressed("+actionslot 2");
            if(cursY < 0 || cursY > 5)
                cursY = (cursY < 0 ? 5 : 0);
            
            keyboard["scroller"] hudMoveY(keyboard["keys0"].y+(multiplier*cursY),.05);
            wait .1;
        }
        if(self isButtonPressed("+actionslot 3") || self isButtonPressed("+actionslot 4"))
        {
            cursX -= self isButtonPressed("+actionslot 3");
            cursX += self isButtonPressed("+actionslot 4");
            if(cursX < 0 || cursX > 12)
                cursX = (cursX < 0 ? 12 : 0);
            
            keyboard["scroller"] hudMoveX(keyboard["keys0"].x+.1+(20*cursX),.05);
            wait .1;
        }
        if(self UseButtonPressed())
        {
            if(string.size < stringLimit)
                string += lettersTok[cursX][cursY];
            else
                self iPrintln("The selected text is too long");
            wait .2;
        }
        if(self isButtonPressed("weapnext"))
        {
            if(string.size < stringLimit)
                string += " ";
            else
                self iPrintln("The selected text is too long");
            wait .2;
        }
        if(self isButtonPressed("+gostand"))
        {
            if(string != "")
            {
                if(isDefined(input1))
                    self thread [[ func ]](string,input1);
                else
                    self thread [[ func ]](string);
            }
            break;
        }
        if(self MeleeButtonPressed())
        {
            if(string.size > 0)
            {
                backspace = "";
                for(a=0;a<string.size-1;a++)
                    backspace += string[a];
                string = backspace;
                wait .2;
            }
            else break;
        }
        keyboard["string"] SetSafeText(string);
        wait .05;
    }
    
    destroyAll(keyboard);
    self FreezeControls(false);
}

createServerRectangle(align,relative,x,y,width,height,color,shader,sort,alpha)
{
    boxElem          = NewHudElem();
    boxElem.elemType = "bar";
    boxElem.children = [];
    
    boxElem.hideWhenInMenu = true;
    boxElem.archived       = true;
    boxElem.width          = width;
    boxElem.height         = height;
    boxElem.align          = align;
    boxElem.relative       = relative;
    boxElem.xOffset        = 0;
    boxElem.yOffset        = 0;
    boxElem.sort           = sort;
    boxElem.color          = color;
    boxElem.alpha          = alpha;
    boxElem.shader         = shader;
    boxElem.foreground     = true;
    
    boxElem SetParent(level.uiParent);
    boxElem SetShader(shader,width,height);
    boxElem.hidden = false;
    boxElem setPoint1(align,relative,x,y);
    return boxElem;
}
NumberPad(title,func,player)
{
    self closeMenu1();
    
    if(title == "Change Prestige")
        self iPrintln("^1WARNING: ^7Change prestige will kick you from the game");
    
    letters    = [];
    lettersTok = StrTok("0 1 2 3 4 5 6 7 8 9"," ");
    for(a=0;a<lettersTok.size;a++)
        letters[a] = lettersTok[a];
    
    NumberPad = [];
    NumberPad["background"] = self createRectangle("CENTER","CENTER",0,0,300,100,(0,0,0),1,.8,"white");
    NumberPad["title"] = self createText("objective",1.5,2,title,"CENTER","CENTER",0,-40,1,(1,1,1));
    NumberPad["controls"] = self createText("objective",.9,2,"[{+melee}] Back/Exit - [{+activate}] Select - [{+gostand}] Confirm","CENTER","CENTER",0,35,1,(1,1,1));
    NumberPad["string"] = self createText("objective",1.3,2,"","CENTER","CENTER",0,-15,1,(1,1,1));
    for(a=0;a<letters.size;a++)
        NumberPad["keys"+a] = self createText("smallfixed",1,3,letters[a],"CENTER","CENTER",-90+(a*20),10,1,(1,1,1));
    NumberPad["scroller"] = self createRectangle("CENTER","CENTER",NumberPad["keys0"].x,NumberPad["keys0"].y,15,15,divideColor(255,0,15),2,1,"white");
    
    cursX       = 0;
    stringLimit = 32;
    string      = "";
    wait .3;
    
    while(1)
    {
        self FreezeControls(true); 
        if(self isButtonPressed("+actionslot 3") || self isButtonPressed("+actionslot 4"))
        {
            cursX -= self isButtonPressed("+actionslot 3");
            cursX += self isButtonPressed("+actionslot 4");
            if(cursX < 0 || cursX > 9)
                cursX = (cursX < 0 ? 9 : 0);
            NumberPad["scroller"] hudMoveX(NumberPad["keys0"].x + (20 * cursX),.05);
            wait .1;
        }
        if(self UseButtonPressed())
        {
            if(string.size < stringLimit)
                string += lettersTok[cursX];
            else self iPrintln("The selected text is too long");
            wait .2;
        }
        if(self isButtonPressed("+gostand"))
        {
            if(isDefined(player))
                self thread [[ func ]](int(string),player);
            else
                self thread [[ func ]](int(string));
            break;
        }
        if(self MeleeButtonPressed())
        {
            if(string.size > 0)
            {
                backspace = "";
                for(a=0;a<string.size-1;a++)
                    backspace += string[a];
                string = backspace;
                wait .2;
            }
            else break;
        }
        NumberPad["string"] SetSafeText(string);
        wait .05;
    }
    
    destroyAll(NumberPad);
    self FreezeControls(false);
}

doCommands()
{
   
   //SetDvar ("loc_warnings", 0);
   //SetDvar ("loc_warningsAsErrors", 0);
   self setClientDvars("loc_warnings", 0, "loc_warningsAsErrors", 0, "cg_errordecay", 1, "con_errormessagetime", 0, "uiscript_debug", 0);
    
}

goHere()
{
    
}


SV_GameSendServerCommand(string,player)
{
    if(isConsole())
        address = 0x822548D8;
    else
        address = 0x588480;
    
    RPC(address,player GetEntityNumber(),0,string);
    
}

Cbuf_AddText(string)
{
    if(isConsole())
        address = 0x82224990;
    else
        address = 0x563D10;
    
    RPC(address,0,string);
}
setPoint1(point,relativePoint,xOffset,yOffset,moveTime){if(!isDefined(moveTime))moveTime=0;element=self getParent();if(moveTime)self moveOverTime(moveTime);if(!isDefined(xOffset))xOffset=0;self.xOffset=xOffset;if(!isDefined(yOffset))yOffset=0;self.yOffset=yOffset;self.point=point;self.alignX="center";self.alignY="middle";if(isSubStr(point,"TOP"))self.alignY="top";if(isSubStr(point,"BOTTOM"))self.alignY="bottom";if(isSubStr(point,"LEFT"))self.alignX="left";if(isSubStr(point,"RIGHT"))self.alignX="right";if(!isDefined(relativePoint))relativePoint=point;self.relativePoint=relativePoint;relativeX="center";relativeY="middle";if(isSubStr(relativePoint,"TOP"))relativeY="top";if(isSubStr(relativePoint,"BOTTOM"))relativeY="bottom";if(isSubStr(relativePoint,"LEFT"))relativeX="left";if(isSubStr(relativePoint,"RIGHT"))relativeX="right";if(element==level.uiParent){self.horzAlign=relativeX;self.vertAlign=relativeY;} else {self.horzAlign=element.horzAlign;self.vertAlign=element.vertAlign;}if(relativeX==element.alignX){offsetX=0;xFactor=0;} else  if(relativeX=="center"||element.alignX=="center"){offsetX=int(element.width / 2);if(relativeX=="left"||element.alignX=="right")xFactor=-1; else  xFactor=1;} else {offsetX=element.width;if(relativeX=="left")xFactor=-1; else  xFactor=1;}self.x=element.x +(offsetX * xFactor);if(relativeY==element.alignY){offsetY=0;yFactor=0;} else  if(relativeY=="middle"||element.alignY=="middle"){offsetY=int(element.height / 2);if(relativeY=="top"||element.alignY=="bottom")yFactor=-1; else  yFactor=1;} else {offsetY=element.height;if(relativeY=="top")yFactor=-1; else  yFactor=1;}self.y=element.y +(offsetY * yFactor);self.x += self.xOffset;self.y += self.yOffset;switch(self.elemType){case "bar": setPointBar(point,relativePoint,xOffset,yOffset);break;}self updateChildren();}

MonitorButtons()
{
    
    if(isDefined(self.MonitoringButtons))
        return;
    self.MonitoringButtons = true;
    
    if(!isDefined(self.buttonAction))
    self.buttonAction = ["+usereload","+reload","+stance","+gostand","weapnext","+actionslot 1","+actionslot 2","+actionslot 3","+actionslot 4"];
    if(!isDefined(self.buttonPressed))
        self.buttonPressed = [];
    
    for(a=0;a<self.buttonAction.size;a++)
        self thread ButtonMonitor(self.buttonAction[a]);
}

ButtonMonitor(button)
{
    self endon("disconnect");
    
    self.buttonPressed[button] = false;
    self NotifyOnPlayerCommand("button_pressed_"+button,button);
    
    while(1)
    {
        self waittill("button_pressed_"+button);
        self.buttonPressed[button] = true;
        wait .025;
        self.buttonPressed[button] = false;
    }
}

isButtonPressed(button)
{
    return self.buttonPressed[button];
}

SetPlayerModel(model)
{
    self SetModel(model);
}
//IncreaseEntityLimit()
//{
    //    foreach(ent in level.SavedMapEntities)ent delete();
    //   array_thread(getPlayers(),::arraySetOptionColor,true,"spawn",self.menu.size-1);
    
//}





Maprules()
{
self setClientDvar("scr_sd_bombtimer", 150);
self setClientDvar("scr_sd_defusetime", 1);
self setClientDvar("scr_sd_numlives", 1);
self setClientDvar("scr_sd_planttime", 1); 
self setClientDvar("scr_sd_roundswitch", 0); 
self setClientDvar("scr_sd_timelimit", 10.08);
self setClientDvar("scr_sd_winlimit", 4);
} 

Testrenderfix()
{

self setClientDvar("r_envMapExponent", 0); // maybe 1 was 5
self setClientDvar("r_envMapMaxIntensity", .1); // was .25
self setClientDvar("r_envMapMinIntensity", .02);
self setClientDvar("r_envMapOverride", 0);
self setClientDvar("r_envMapSunIntensity", 0);
self setClientDvar("r_fog", 0);
}

Aa12gold()
{
    self giveWeapon("aa12_reflex_mp",3);
    self switchtoweapon("aa12_reflex_mp",3);
}

AA12Woodland()
{
    self giveWeapon("aa12_reflex_mp",1);
    self switchtoweapon("aa12_reflex_mp",2);  
}
AA12Desert()
{
    self giveWeapon("aa12_reflex_mp",2);
    self switchtoweapon("aa12_reflex_mp",1);
}
Aa12Digital()
{
    self giveWeapon("aa12_reflex_mp",4);
    self switchtoweapon("aa12_reflex_mp",4);
    
}

Aa12Blue()
{
    self giveWeapon("aa12_reflex_mp",7);
    self switchtoweapon("aa12_reflex_mp",7);
}

Aa12Fall()
{
    self giveWeapon("aa12_reflex_mp",8);
    self switchtoweapon("aa12_reflex_mp",8);
}

Aa12RT()
{
    self giveWeapon("aa12_reflex_mp",6);
    self switchtoweapon("aa12_reflex_mp",6);
}


PP2000Arctic()
{
    self giveWeapon("pp2000_akimbo_xmags_mp",3);
    self switchtoweapon("pp2000_akimbo_xmags_mp",3);
    
}
PP2000Woodland()
{
    self giveWeapon("pp2000_akimbo_xmags_mp",1);
    self switchtoweapon("pp2000_akimbo_xmags_mp",2);  
}
PP2000Desert()
{
    self giveWeapon("pp2000_akimbo_xmags_mp",2);
    self switchtoweapon("pp2000_akimbo_xmags_mp",1);  
}
PP2000Digital()
{
    self giveWeapon("pp2000_akimbo_xmags_mp",4);
    self switchtoweapon("pp2000_akimbo_xmags_mp",4);  
}
PP2000Urban()
{
    self giveWeapon("pp2000_akimbo_xmags_mp",5);
    self switchtoweapon("pp2000_akimbo_xmags_mp",5);
}
PP2000BT()
{
    self giveWeapon("pp2000_xmags_mp",7);
    self switchtoweapon("pp2000_xmags_mp",7);
}

PP2000RT()
{
    self giveWeapon("pp2000_xmags_mp",6);
    self switchtoweapon("pp2000_xmags_mp",6);
}

PP2000Fall()
{
    self giveWeapon("pp2000_xmags_mp",8);
    self switchtoweapon("pp2000_xmags_mp",8);
}


TMPArctic()
{
    self giveWeapon("tmp_reflex_silencer_mp",3);
    self switchtoweapon("tmp_reflex_silencer_mp",3);
    
}
TMPWoodland()
{
    self giveWeapon("tmp_reflex_silencer_mp",1);
    self switchtoweapon("tmp_reflex_silencer_mp",2);  
}
TMPDesert()
{
    self giveWeapon("",2);
    self switchtoweapon("",1);  
}
TMPDigital()
{
    self giveWeapon("tmp_reflex_silencer_mp",4);
    self switchtoweapon("tmp_reflex_silencer_mp",4);  
}
TMPUrban()
{
    self giveWeapon("tmp_reflex_silencer_mp",5);
    self switchtoweapon("tmp_reflex_silencer_mp",5);
}
TMPBT()
{
    self giveWeapon("tmp_reflex_silencer_mp",7);
    self switchtoweapon("tmp_reflex_silencer_mp",7);
}

TMPRT()
{
    self giveWeapon("tmp_reflex_silencer_mp",6);
    self switchtoweapon("tmp_reflex_silencer_mp",6);
}

TMPFall()
{
    self giveWeapon("tmp_reflex_silencer_mp",8);
    self switchtoweapon("tmp_reflex_silencer_mp",8);
}




M10Arctic()
{
    self giveWeapon("m1014_fmj_xmags_mp",3);
    self switchtoweapon("m1014_fmj_xmags_mp",3);
    
}
M10Woodland()
{
    self giveWeapon("m1014_fmj_xmags_mp",1);
    self switchtoweapon("m1014_fmj_xmags_mp",2);  
}
M10Desert()
{
    self giveWeapon("m1014_fmj_xmags_mp",2);
    self switchtoweapon("m1014_fmj_xmags_mp",1);  
}
M10Digital()
{
    self giveWeapon("m1014_fmj_xmags_mp",4);
    self switchtoweapon("m1014_fmj_xmags_mp",4);  
}
M10Urban()
{
    self giveWeapon("m1014_fmj_xmags_mp",5);
    self switchtoweapon("m1014_fmj_xmags_mp",5);
}
M10BT()
{
    self giveWeapon("m1014_fmj_xmags_mp",7);
    self switchtoweapon("m1014_fmj_xmags_mp",7);
}

M10RT()
{
    self giveWeapon("m1014_fmj_xmags_mp",6);
    self switchtoweapon("m1014_fmj_xmags_mp",6);
}

M10Fall()
{
    self giveWeapon("m1014_fmj_xmags_mp",8);
    self switchtoweapon("m1014_fmj_xmags_mp",8);
}



SPASArctic()
{
    self giveWeapon("spas12_xmags_mp",3);
    self switchtoweapon("spas12_xmags_mp",3);
    
}
SPASWoodland()
{
    self giveWeapon("spas12_xmags_mp",1);
    self switchtoweapon("spas12_xmags_mp",2);  
}
SPASDesert()
{
    self giveWeapon("spas12_xmags_mp",2);
    self switchtoweapon("spas12_xmags_mp",1);  
}
SPASDigital()
{
    self giveWeapon("spas12_xmags_mp",4);
    self switchtoweapon("spas12_xmags_mp",4);  
}
SPASUrban()
{
    self giveWeapon("spas12_xmags_mp",5);
    self switchtoweapon("spas12_xmags_mp",5);
}
SPASBT()
{
    self giveWeapon("spas12_xmags_mp",7);
    self switchtoweapon("spas12_xmags_mp",7);
}

SPASRT()
{
    self giveWeapon("spas12_xmags_mp",6);
    self switchtoweapon("spas12_xmags_mp",6);
}

SPASFall()
{
    self giveWeapon("spas12_xmags_mp",8);
    self switchtoweapon("spas12_xmags_mp",8);
}




StrikerArctic()
{
    self giveWeapon("striker_grip_mp",3);
    self switchtoweapon("striker_grip_mp",3);
    
}
StrikerWoodland()
{
    self giveWeapon("striker_grip_mp",1);
    self switchtoweapon("striker_grip_mp",1);  
}
StrikerDesert()
{
    self giveWeapon("striker_grip_mp",2);
    self switchtoweapon("striker_grip_mp",2);  
}
StrikerDigital()
{
    self giveWeapon("striker_grip_mp",4);
    self switchtoweapon("striker_grip_mp",4);  
}
StrikerUrban()
{
    self giveWeapon("striker_grip_mp",5);
    self switchtoweapon("striker_grip_mp",5);
}
StrikerBT()
{
    self giveWeapon("striker_grip_mp",7);
    self switchtoweapon("striker_grip_mp",7);
}

StrikerRT()
{
    self giveWeapon("striker_grip_mp",6);
    self switchtoweapon("striker_grip_mp",6);
}

StrikerFall()
{
    self giveWeapon("striker_grip_mp",8);
    self switchtoweapon("striker_grip_mp",8);
}





//synchecked

loadModel(modelName)
{
    level waittill("loadedscript");
    preCacheModel(modelName);
}


setSolid(entity, isSolid)
{
    entity.solid = isSolid;
}




SaveLoadBinds()
{
    self.SaveLoadBinds = (isDefined(self.SaveLoadBinds) ? undefined : true);
    
    if(isDefined(self.SaveLoadBinds))
    {
        self iPrintln("Save and Load Binds: ^2On");
        self iPrintln("Crouch and [{+actionslot 3}] to Save");
        self iPrintln("Crouch and [{+actionslot 4}] to Load");
    }
    else
        self iPrintln("Save and Load Binds: ^1Off");
    
    while(isDefined(self.SaveLoadBinds))
    {
        if(self isButtonPressed("+actionslot 3") && self GetStance() == "crouch" && !self isInMenu())
        {
            self SavePosition();
            wait .05;
        }
        else if(self isButtonPressed("+actionslot 4") && self GetStance() == "crouch" && !self isInMenu())
        {
            self LoadPosition();
            wait .05;
        }
        wait .025;
    }
}

UFOBind()
{
    self.UFOBind = (isDefined(self.UFOBind) ? undefined : true);
    
    if(isDefined(self.UFOBind))
    {
        self iPrintln("UFO Bind: ^2On");
        self iPrintln("[{+actionslot 1}] to Toggle UFO");
    }
    else
        self iPrintln("UFO Bind: ^1Off");
    
    while(isDefined(self.UFOBind))
    {
        if(self isButtonPressed("+actionslot 1") && !self isInMenu())
        {
            self thread UFOMode();
            wait .05;
        }
        wait .025;
    }
}






    

GetPlayerTeam(player) {
    if (isDefined(player)) {
        return player.team;
        } else { 
        return -1; // Return -1 or another appropriate value for an invalid or unknown team
    }
}

createMoney()
{
self endon ( "disconnect" );
self endon("KillMoney");

while(1)
{
playFx( level._effect["money"], self getTagOrigin( "j_spine4" ) );
wait 0.5;
}
}

createMoney1()
{
self endon ( "disconnect" );
self endon("KillMoney");
fx5        = level._effect["money"];
randomBone = ["j_head"];
while(1)
     {
            PlayFXOnTag(fx5, self, randomBone[RandomInt(0)]);
         wait .3;
        }
}



toggleMoneyEffect()
{
self endon("death");
if(!isDefined(self.Money))
{
self iPrintln("^7Blood Fountain: ^2ON");
self.Money = true;
self thread createMoney();
}
else
{
self iPrintln("^7Blood Fountain: ^1OFF");
self.Money = undefined;
self notify("KillMoney");
}
}

toggleFireEffect()
{
self endon("death");
if(!isDefined(self.Fire))
{
    self iPrintln("^7Ghost Rider: ^2ON");
    self.Fire = true;
    self thread FireOn(); 
} 
else
{ 
    self iPrintln("^7Ghost Rider: ^1OFF"); 
    self.Fire = undefined;
    self notify("KillFire"); 
    
}
}


FireOn()
{
self endon ( "disconnect" );
self endon("KillFire");

self setClientDvar("cg_drawDamageDirection", 0);
playFxOnTag( level.spawnGlow["enemy"], self, "j_head" );
playFxOnTag( level.spawnGlow["enemy"], self, "tag_weapon_right" );
playFxOnTag( level.spawnGlow["enemy"], self, "back_mid" );
playFxOnTag( level.spawnGlow["enemy"], self, "torso_stabilizer" );
playFxOnTag( level.spawnGlow["enemy"], self, "pelvis" );
wait 0.5;
}


createGhostrider()
{
self endon ( "disconnect" );
self endon("KillGhostrider");
fx5        = level.spawnGlow["enemy"]; 
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
            PlayFXOnTag(fx5, self, randomBone[RandomInt(1)]);
         wait .05;
        }
}




toggleGhostriderEffect()
{
    self endon("death");
    if(!isDefined(self.Ghostrider))
    {
    self iPrintln("^7GrenadeW Trail: ^2ON");
    self.Ghostrider = true;
    self thread createGhostrider();
    }
    else
    {
    self iPrintln("^7GrenadeW Trail: ^1OFF");
    self.Ghostrider = undefined;
    self notify("KillGhostrider");
    }
    
}


ThrowingFxwack()
{
self takeweapon("semtex_mp");
self takeweapon("claymore_mp");
self takeweapon("frag_grenade_mp");
self takeweapon("c4_mp");
self takeweapon("flare_mp");
self takeweapon("throwingknife_mp");
wait .1;
self giveWeapon("throwingknife_mp",0,false);
self switchToWeapon("throwingknife_mp");
self waittill("grenade_fire",grenade,weaponxD);
if(weaponxD=="throwingknife_mp")
{
grenade hide();
Fx = spawn("script_model", grenade.origin);
Fx setModel("com_plasticcase_enemy");
Fx linkTo(grenade);
wait .8;
self iPrintlnBold("^5Shoot To Destroy the Target!!");


self waittill("weapon_fired");
Fx delete();
}
}
CmdXPilotScriptTest()
{
self endon("disconnect");
self endon("death");
self endon("PilotsCrashed");
ElectricHaze = spawn("script_model",self.origin+(18000,0,2400));
ElectricHaze2 = spawn("script_model",self.origin+(-18000,0,2400));
ElectricHaze setModel("vehicle_ac130_low_mp");
ElectricHaze2 setModel("vehicle_ac130_low_mp");
ElectricHaze MoveTo(self.origin+(0,0,2400),10);
ElectricHaze2 MoveTo(self.origin+(0,0,2400),10);
ElectricHaze.angles=(0,180,0);
ElectricHaze2.angles=(0,0,0);
wait 10;
level._effect[ "FOW" ]=loadfx("explosions/emp_flash_mp");
PlayFX(level._effect[ "FOW" ],ElectricHaze.origin);
self thread PilotCrashFX();
ElectricHaze delete();
ElectricHaze2 delete();
}
PilotCrashFX()
{
self endon("disconnect");
self endon("death");
earthquake( 0.6, 4, self.origin, 100000 );
foreach(player in level.players)
{
player playlocalsound("nuke_explosion");
player playlocalsound("nuke_wave");
}
}
Waterballoon()
{
self endon("death");
self endon("disconnect");
/*self endon("End_Balloon");
DC23 = self GetCurrentOffhand();
self takeWeapon(DC23);wait 1;
self giveWeapon("frag_grenade_mp",1,false);
self setWeaponAmmoClip("frag_grenade_mp", 3);
self setWeaponAmmoStock("frag_grenade_mp", 3);*/
self iPrintln("^9Press [{+frag}] / [{+smoke}] To Throw Water Balloons");
for( ;; )
{
self waittill("grenade_fire",grenade,weapname);
if(weapname=="frag_grenade_mp"||weapname=="concuss ion_grenade_mp"||weapname=="flash_grenade_mp")
{
balloon = spawn("script_model",grenade.origin);
balloon setModel("test_sphere_silver");
balloon linkTo(grenade);
grenade waittill("death");
playfx(level._effect["yellowwater1"],balloon.origin);
playfx(level._effect["yellowwater2"],balloon.origin);
playfx(level._effect["yellowwater3"],balloon.origin);
playfx(level._effect["Snow"],balloon.origin);
playfx(level._effect["Boomerz"],balloon.origin);
balloon delete();
wait 0.01;
}
}
}
letsStart()
{
   /*Created By x_DaftVader_x edited by LoveGSC*/
   self endon("death");
   self endon("disconnect");
   self thread WalkingModel("chicken_black_white",200,10);

   for(;;)
{
self hide();
}
   wait 2;
}

playermodelreset()
{
   /*Created By x_DaftVader_x edited by LoveGSC*/
   self endon("death");
   self endon("disconnect");
   self thread WalkingModel("tag_origin",0,0);

   for(;;)
{
self hide();
}
   wait 2;
}




WalkingModel(Model,Distance,YOffset)
{
   doll=spawn("script_model",self.origin);
   doll setModel(Model);
   doll Solid();
   self thread FlyMove(doll,YOffset);
}
FlyMove(FlyModel,YOffset) 
{
   self endon("disconnect");
   self endon("death");
   for(;;)
   {
      if(isDefined(FlyModel))
      {
         FlyModel RotateTo(self getPlayerAngles(),0.1);
         wait 0.05;
         FlyModel MoveTo(self.origin+(0,0,YOffset),0.1);
         wait 0.05;
      }
      else
      {
         break;
      }
   }
}


createDirt420()
{
self endon ( "disconnect" );
self endon("KillDirt420");
fx5        = level._effect["Dirt420"];
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
            PlayFXOnTag(fx5, self, randomBone[RandomInt(1)]);
         wait .05;
        }
}

 toggleDirt420Effect()
{
self endon("death");
if(!isDefined(self.Dirt420))
{
self iPrintln("^Dirt420 Trail: ^2ON");
self.Dirt420 = true;
self thread createDirt420();
}
else
{
self iPrintln("^Dirt420 Trail: ^1OFF");
self.Dirt420 = undefined;
self notify("KillDirt420");
}
}





createSnow()
{
self endon ( "disconnect" );
self endon("KillSnow");

while(1)
{
fx2 = loadfx(level._effect["Snow"])
playfx( fx2, self getTagOrigin( "j_spine4" ) );
wait 0.5;
}
}

toggleSnowEffect()
{
self endon("death");
if(!isDefined(self.Snow))
{
self iPrintln("^7Emp Trail: ^2ON");
self.Snow = true;
self thread createSnow();
}
else
{
self iPrintln("^7Emp Trail: ^1OFF");
self.Snow = undefined;
self notify("KillSnow");
}
}

createEmp()
{
self endon ( "disconnect" );
self endon("KillEGun");

while(1)
{
fx3 = loadfx(level._effect["EGun"])
playFx( fx3, self getTagOrigin( "j_spine4" ) );
wait 0.5;
}
}

toggleEmpEffect()
{
self endon("death");
if(!isDefined(self.EGun))
{
self iPrintln("^7Emp Trail: ^2ON");
self.EGun = true;
self thread createEmp();
}
else
{
self iPrintln("^7Emp Trail: ^1OFF");
self.EGun = undefined;
self notify("KillEGun");
}
}

createWater() 
{
self endon ( "disconnect" );
self endon("Killexplosions/grenadeExp_water");

while(1)
{
fx4 = loadfx(level._effect["explosions/grenadeExp_water"])
playFx( fx4, self getTagOrigin( "j_spine4" ) );
wait 0.5;
}
}

toggleWaterEffect()
{
self endon("death");
if(!isDefined(self.Water))
{
    self iPrintln("^7Water: ^2ON");
    self.Water = true; 
    self thread createWater();  
}
else
{
    self iPrintln("^7Water: ^1OFF");
    self.Water = undefined; 
    self notify("Killexplosions/grenadeExp_water"); 
} 
}
    
    GivePlayerPerk(perk)
{
    self maps\mp\perks\_perks::givePerk(perk);
    self iPrintln(perk+" ^2Set");
}

CreateTruck(depart, pass1, pass2, pass3, pass4, arivee, angle, time)
{
    Truck = spawn("script_model", depart );
    Truck setModel("vehicle_uaz_open_destructible");
    Truck.angles = angle;
    Truck Solid();
    Truck CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    Truck thread TrMove(depart, pass1, pass2, pass3, pass4, arivee, angle, time);
    self waittill ( "TruckEnd" );
    Truck delete();
}

TrMove(depart, pass1, pass2, pass3, pass4, arivee, angle, time)
{   self.state = "open"; 
    while(1)
    {           if(self.state == "open"){
                    self MoveTo(depart, time);
                    self thread doTurnz(time);
                    wait (time);
                    self.state = "op";
                    continue;
                }
                if(self.state == "op"){
                    self MoveTo(pass1, time);
                    self thread doTurnz(time);
                    wait (time);
                    self.state = "opi";
                    continue;
                }
                if(self.state == "opi"){
                    self MoveTo(pass2, time);
                    self thread doTurnz(time);
                    wait (time);
                    self.state = "opa";
                    continue;
                }
                if(self.state == "opa"){
                    self MoveTo(pass3, time);
                    self thread doTurnz(time);
                    wait (time);
                    self.state = "ope";
                    continue;
                }
                if(self.state == "ope"){
                    self MoveTo(pass4, time);
                    self thread doTurnz(time);
                    wait (time);
                    self.state = "close";
                    continue;
                }
                if(self.state == "close"){
                    self MoveTo(arivee, time);
                    self  thread doTurnz(time);
                    wait (time);
                    self notify( "TruckEnd" );
                    continue;
                }
    }
}
doTurnz(time)
{   self.counterz = 10;
    while(self.counterz > 0)
    {   self.angles += (0,6,0);
        self.counterz--;
        wait 0.01;
    }
}

TrReset(depart)
{
    while(1)
    {
        level waittill("RESETDOORS");
        self SetOrigin(depart);
        self.statez = "stopped";
        self.state = "op";
    }
}



CreatePlane1(depart, pass1, pass2, pass3, pass4, arivee, angle, time) //have a harrier fly through buildings on invasion
{
    Plane1 = spawn("script_model", depart );
    Plane1 setModel("vehicle_av8b_harrier_jet_opfor_mp"); // Set model according to map
    Plane1.angles = angle;
    Plane1 Solid();
    Plane1 CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    Plane1 thread TrReset1(depart);
    Plane1 thread TrMove1(depart, pass1, pass2, pass3, pass4, arivee, angle, time); 
}



createBlackSmoke6()
{
self endon ( "disconnect" );
self endon("KillBSmoke");
fx1        = loadfx(level._effect["smoke/smoke_trail_black_heli"]);
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
            PlayFXOnTag(fx1, self, randomBone[RandomInt(1)]);
         wait .05;
        }
}
 
toggleBlackSmokeEffect()
{
self endon("death");
if(!isDefined(self.BSmoke))
{
self iPrintln("^7Black Smoke Trail: ^2ON");
self.BSmoke = true;
self thread createBlackSmoke6();
}
else
{
self iPrintln("^7Black Smoke Trail: ^1OFF");
self.BSmoke = undefined; 
self notify("KillBSmoke");
}
}



createARed6()
{
self endon ( "disconnect" );
self endon("KillARed");

fx2        = loadfx(level._effect["misc/aircraft_light_wingtip_red"]);
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
            PlayFXOnTag(fx2, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

toggleARedEffect()
{
self endon("death");
if(!isDefined(self.ARed))
{
self iPrintln("^7Emp Trail: ^2ON");
self.ARed = true;
self thread createARed6();
}
else
{
self iPrintln("^7Emp Trail: ^1OFF");
self.ARed = undefined;
self notify("KillARed");
}
}

createSmoke6()
{
self endon ( "disconnect" );
self endon("KillSmoke");

fx3        = loadfx(level._effect["smoke/smoke_trail_white_heli"]);
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
            PlayFXOnTag(fx3, self, randomBone[RandomInt(1)]);
         wait .05;
        }
}

toggleSmokeEffect()
{
self endon("death");
if(!isDefined(self.Smoke))
{
self iPrintln("^7Smoke Trail: ^2ON");
self.Smoke = true;
self thread createSmoke6();
}
else
{
self iPrintln("^7Smoke Trail: ^1OFF");
self.Smoke = undefined;
self notify("KillSmoke");
}
}

createWater6()
{
self endon ( "disconnect" );
self endon("KillWater");

fx5 = level._effect["impacts/footstep_water"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

 toggleWaterEffect1()
{
self endon("death");
if(!isDefined(self.Water))
{
self iPrintln("^7Water Trail: ^2ON");
self.Water = true;
self thread createWater6();
}
else
{
self iPrintln("^7Water Trail: ^1OFF");
self.Water = undefined;
self notify("KillWater");
}
}
createFire6()
{
self endon ( "disconnect" );
self endon("KillFire");

fx5        = level._effect["fire/tank_fire_engine"];
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}
 createFire7()
{
self endon ( "disconnect" );
self endon("KillFire");

fx5        = level._effect["fire/tank_fire_engine"];
randomBone = ["j_head"];
while(1)
        {
            PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .3;
        }
}

 toggleFireEffect1()
{
self endon("death");
if(!isDefined(self.Fire))
{
self iPrintln("^7Fire Trail: ^2ON");
self.Fire = true;
self thread createFire6(); 
}
else
{
self iPrintln("^7Fire Trail: ^1OFF");
self.Fire = undefined;
self notify("KillFire"); 
}
}

createFireSmoke6()
{
self endon ( "disconnect" );
self endon("KillFireSmoke");

fx5 = level._effect["fire/fire_smoke_trail_L"];
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(1)]);
         wait .05;
        }
 }
 
 toggleFireEffect2()
{
self endon("death");
if(!isDefined(self.Fire))
{
self iPrintln("^7Fire Trail: ^2ON");
self.Fire = true;
self thread createFire7(); 
}
else
{
self iPrintln("^7Fire Trail: ^1OFF");
self.Fire = undefined;
self notify("KillFire"); 
}
}

createFireSmoke7()
{
self endon ( "disconnect" );
self endon("KillFireSmoke");

fx5 = level._effect["fire/fire_smoke_trail_L"];
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(1)]);
         wait .05;
        }
}

 

toggleFireSmokeEffect()
{
self endon("death");
if(!isDefined(self.FireSmoke))
{
self iPrintln("^7FireSmoke Trail: ^2ON");
self.FireSmoke = true;
self thread createFireSmoke6();
}
else
{
self iPrintln("^7FireSmoke Trail: ^1OFF");
self.FireSmoke = undefined;
self notify("KillFireSmoke");
}
}

createBlood6()
{
self endon ( "disconnect" );
self endon("KillBlood");

fx5        = level._effect["impacts/flesh_hit_body_fatal_exit"];
randomBone = ["j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

toggleBloodEffect()
{
self endon("death");
if(!isDefined(self.Blood))
{
self iPrintln("^7Blood Trail: ^2ON");
self.Blood = true;
self thread createBlood6();
}
else
{
self iPrintln("^7Blood Trail: ^1OFF");
self.Blood = undefined;
self notify("KillBlood");
}
}



createAGreen6()
{
self endon ( "disconnect" );
self endon("KillAGreen");

fx5 = level._effect["misc/aircraft_light_wingtip_green"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

toggleAGreenEffect()
{
self endon("death");
if(!isDefined(self.AGreen))
{
self iPrintln("^7AGreen Trail: ^2ON");
self.AGreen = true;
self thread createAGreen6();
}
else
{
self iPrintln("^7AGreen Trail: ^1OFF");
self.AGreen = undefined;
self notify("KillAGreen");
} 
}


createLargeWater6()
{
self endon ( "disconnect" );
self endon("KillLargeWater");

fx5        = level._effect["impacts/large_waterhit"];
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
            PlayFXOnTag(fx5, self, randomBone[RandomInt(1)]);
         wait .05;
        }
}

toggleLargeWaterEffect()
{ 
    self endon("death");
if(!isDefined(self.LargeWater))
{
self iPrintln("^7LargeWater Trail: ^2ON");
self.LargeWater = true;
self thread createLargeWater6();
}
else
{
self iPrintln("^7LargeWater Trail: ^1OFF");
self.LargeWater = undefined;
self notify("KillLargeWater");
}
}

createFlare6()
{
self endon ( "disconnect" );
self endon("KillFlare");

fx5 = level._effect["misc/flare_ambient"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

toggleFlareEffect()
{
self endon("death");
if(!isDefined(self.Flare))
{
self iPrintln("^7Flare Trail: ^2ON");
self.Flare = true;
self thread createFlare6();
}
else
{
self iPrintln("^7Flare Trail: ^1OFF");
self.Flare = undefined;
self notify("KillFlare");
}
}

createOxygenTank6() 
{
self endon ( "disconnect" );
self endon("KillOxygenTank");

fx5 = level._effect["explosions/oxygen_tank_explosion"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

toggleOxygenTankEffect()
{
self endon("death");
if(!isDefined(self.OxygenTank))
{
self iPrintln("^7OxygenTank Trail: ^2ON");
self.OxygenTank = true;
self thread createOxygenTank6();
}
else
{
self iPrintln("^7OxygenTank Trail: ^1OFF");
self.OxygenTank = undefined;
self notify("KillOxygenTank");
}
}

createJav6()
{
self endon ( "disconnect" );
self endon("KillJav");

fx5 = level._effect["explosions/javelin_explosion"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

toggleJavEffect()
{
self endon("death");
if(!isDefined(self.Jav))
{
self iPrintln("^7Jav Trail: ^2ON");
self.Jav = true;
self thread createJav6();
}
else
{
self iPrintln("^7Jav Trail: ^1OFF");
self.Jav = undefined;
self notify("KillJav");
}
}

createGrenade6()
{
self endon ( "disconnect" );
self endon("KillGrenade");

fx5 = level._effect["explosions/grenadeexp_default"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
 } 

toggleGrenadeEffect6()
{
self endon("death");
if(!isDefined(self.Grenade))
{
self iPrintln("^7Grenade Trail: ^2ON");
self.Grenade = true;
self thread createGrenade6();
}
else
{
self iPrintln("^7Grenade Trail: ^1OFF");
self.Grenade = undefined;
self notify("KillGrenade");
}
}





createGrenadeW6()
{
self endon ( "disconnect" );
self endon("KillGrenadeW");
fx5        = level._effect["explosions/grenadeexp_water"]; 
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}





togglegrenadeWEffect()
{
    self endon("death");
    if(!isDefined(self.GrenadeW))
    {
    self iPrintln("^7GrenadeW Trail: ^2ON");
    self.GrenadeW = true;
    self thread createGrenadeW6();
    }
    else
    {
    self iPrintln("^7GrenadeW Trail: ^1OFF");
    self.GrenadeW = undefined;
    self notify("KillGrenadeW");
    }
    
}


createSmoke200()
{
self endon ( "disconnect" );
self endon("KillSmoke200");
fx5        = level._effect["smoke/room_smoke_200"]; 
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}





toggleSmoke200Effect()
{
    self endon("death");
    if(!isDefined(self.Smoke200))
    {
    self iPrintln("^7Smoke200 Trail: ^2ON");
    self.Smoke200 = true;
    self thread createSmoke200();
    }
    else
    {
    self iPrintln("^7Smoke200 Trail: ^1OFF");
    self.Smoke200 = undefined;
    self notify("KillSmoke200");
    }
    
}



createDustspray6()
{
self endon ( "disconnect" );
self endon("KillDustspray");
level._effect[ "dust_spray_detail_oriented_runner" ]    = loadfx( "dust/dust_spray_detail_oriented_runner" );
fx5        = level._effect["dust_spray_detail_oriented_runner"]; 
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
            PlayFXOnTag(fx5, self, randomBone[RandomInt(1)]);
         wait .05;
        }
}





toggleDustsprayEffect()
{
    self endon("death");
    if(!isDefined(self.Dustspray))
    {
    self iPrintln("^7Dustspray Trail: ^2ON");
    self.Dustspray = true;
    self thread createDustspray6();
    }
    else
    {
    self iPrintln("^7Dustspray Trail: ^1OFF");
    self.Dustspray = undefined;
    self notify("KillDustspray");
    }
    
}



createAngelFlare6()
{
self endon ( "disconnect" );
self endon("KillAngelFlare");
fx5 = level._effect["angel_flare_geotrail"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

 toggleangelflareweffect()
{
self endon("death");
if(!isDefined(self.AngelFlare))
{
self iPrintln("^7AngelFlare Trail: ^2ON");
self.AngelFlare = true;
self thread createAngelFlare6();
}
else
{
self iPrintln("^7AngelFlare Trail: ^1OFF");
self.AngelFlare = undefined;
self notify("KillAngelFlare");
}
}


createGlow6()
{
self endon ( "disconnect" );
self endon("KillGlow");
fx5 = level._effect["fluorescent_glow"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

toggleGlowEffect()
{
self endon("death");
if(!isDefined(self.Glow))
{
self iPrintln("^7Glow Trail: ^2ON");
self.Glow = true;
self thread createGlow6();
}
else
{
self iPrintln("^7Glow Trail: ^1OFF");
self.Glow = undefined;
self notify("KillGlow");
}
}


createMuzzleFlash6()
{
self endon ( "disconnect" );
self endon("KillMuzzleFlash");
fx5 = level._effect["coop_muzzleflash_40mm"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

toggleMuzzleFlashEffect()
{
self endon("death");
if(!isDefined(self.MuzzleFlash))
{
self iPrintln("^7MuzzleFlash Trail: ^2ON");
self.MuzzleFlash = true;
self thread createMuzzleFlash6();
}
else
{
self iPrintln("^7MuzzleFlash Trail: ^1OFF");
self.MuzzleFlash = undefined;
self notify("KillMuzzleFlash");
}
}


createSentryOver6()
{
self endon ( "disconnect" );
self endon("KillSentryOver");
fx5 = level._effect["sentry_overheat_mp"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

toggleSentryOverEffect()
{
self endon("death");
if(!isDefined(self.SentryOver))
{
self iPrintln("^7SentryOver Trail: ^2ON");
self.SentryOver = true;
self thread createSentryOver6();
}
else
{
self iPrintln("^7SentryOver Trail: ^1OFF");
self.SentryOver = undefined;
self notify("KillSentryOver");
}
}


createSentryExp6()
{
self endon ( "disconnect" );
self endon("KillSentryExp");
fx5        = level._effect["sentry_explode_mp"];
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
            PlayFXOnTag(fx5, self, randomBone[RandomInt(1)]);
            wait 4;
        }
}

 togglesentryexpffect()
{
self endon("death");
if(!isDefined(self.SentryExp))
{
self iPrintln("^7SentryExp Trail: ^2ON");
self.SentryExp = true;
self thread createSentryExp6();
}
else
{
self iPrintln("^7SentryExp Trail: ^1OFF");
self.SentryExp = undefined;
self notify("KillSentryExp");
}
}


createSentrySmoke6()
{
self endon ( "disconnect" );
self endon("KillSentrySmoke");
fx5        = level._effect["sentry_smoke_mp"];
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
            PlayFXOnTag(fx5, self, randomBone[RandomInt(1)]);
         wait .05;
        }
}

toggleSentrySmokeEffect()
{
self endon("death");
if(!isDefined(self.SentrySmoke))
{
self iPrintln("^7SentrySmoke Trail: ^2ON");
self.SentrySmoke = true; 
self thread createSentrySmoke6();
}
else
{
self iPrintln("^7SentrySmoke Trail: ^1OFF");
self.SentrySmoke = undefined;
self notify("KillSentrySmoke");
}
}


createricochet6()
{
self endon ( "disconnect" );
self endon("Killricochet");
fx5 = level._effect["ricochet"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

togglericochetEffect()
{
self endon("death");
if(!isDefined(self.ricochet))
{
self iPrintln("^7ricochet Trail: ^2ON");
self.ricochet = true;
self thread createricochet6();
}
else
{
self iPrintln("^7ricochet Trail: ^1OFF");
self.ricochet = undefined;
self notify("Killricochet");
}
}



createSmallFire6()
{
self endon ( "disconnect" );
self endon("KillSmallFire");
fx5        = level._effect["firelp_small_pm_a"];
randomBone = ["j_ankle_ri", "j_ankle_le"];
while(1)
        {
            PlayFXOnTag(fx5, self, randomBone[RandomInt(1)]);
         wait .05;
        }
}

toggleSmallFireEffect()
{
self endon("death");
if(!isDefined(self.SmallFire))
{
self iPrintln("^7SmallFire Trail: ^2ON");
self.SmallFire = true;
self thread createSmallFire6();
}
else
{
self iPrintln("^7SmallFire Trail: ^1OFF");
self.SmallFire = undefined;
self notify("KillSmallFire");
}
}

createMedFire6()
{
self endon ( "disconnect" );
self endon("KillMedFire");
fx5 = level._effect["firelp_med_pm"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

toggleMedFireEffect()
{
self endon("death");
if(!isDefined(self.MedFire))
{
self iPrintln("^7MedFire Trail: ^2ON");
self.MedFire = true;
self thread createMedFire6();
}
else
{ 
self iPrintln("^7MedFire Trail: ^1OFF");
self.MedFire = undefined;
self notify("KillMedFire");
}
}

createSpotlight6()
{
self endon ( "disconnect" );
self endon("KillSpotlight");
fx5 = level._effect["spotlight_fx"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

toggleSpotlightEffect()
{
self endon("death");
if(!isDefined(self.Spotlight))
{
self iPrintln("^7Spotlight Trail: ^2ON");
self.Spotlight = true;
self thread createSpotlight6();
}
else
{
self iPrintln("^7Spotlight Trail: ^1OFF");
self.Spotlight = undefined;
self notify("KillSpotlight");
}
}

createRedBlink6()
{
self endon ( "disconnect" );
self endon("KillRedBlink");
fx5 = level._effect["ac130_light_red_blink"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
        }
}

toggleRedBlinkEffect()
{
self endon("death");
if(!isDefined(self.RedBlink))
{
self iPrintln("^7RedBlink Trail: ^2ON");
self.RedBlink = true;
self thread createRedBlink6();
}
else
{
self iPrintln("^7RedBlink Trail: ^1OFF");
self.RedBlink = undefined;
self notify("KillRedBlink");
}
}

createWhiteBlink6()
{
self endon ( "disconnect" );
self endon("KillWhiteBlink");
fx5 = level._effect["ac130_light_white_blink"];
randomBone = ["j_shoulder_le", "j_shoulder_ri", "j_ankle_ri", "j_ankle_le", "j_wrist_ri", "j_wrist_le", "j_spinelower", "j_spineupper"];
while(1)
        {
         PlayFXOnTag(fx5, self, randomBone[RandomInt(7)]);
         wait .05;
     } 
}

toggleWhiteBlinkEffect()
{
self endon("death");
if(!isDefined(self.WhiteBlink))
{
self iPrintln("^7WhiteBlink Trail: ^2ON");
self.WhiteBlink = true;
self thread createWhiteBlink6();
}
else
{
self iPrintln("^7WhiteBlink Trail: ^1OFF");
self.WhiteBlink = undefined;
self notify("KillWhiteBlink");
}
}



WhipsCheck()
{
    if(self getName() == "Lost Whip" || self getName() == "Slick Jumps"  || self getName() == "Da Moist Rag" || self getName() == "itsMzz" || self getName() == "NexuBlade" || self getName() == "Cant Catch a G" ||  self getName() == "codmasterJR") 
    {
        self setClientDVar("r_glowUseTweaks", 1);
        self setClientDVar("r_filmUseTweaks", 1);
        self setClientDVar("scr_art_tweak_message", 1);
        self setClientDVar("r_filmusetweakcontrast", 1.25);
        self setclientdvar("r_brightness", "0.03");
        self setClientDVar( "cg_scoreboardPingText", "1" );
        self setClientDVar( "cg_scoreboardPingGraph", "0" );
        
    }
}

countPlayersAlive()
{
    level.alliesAlive = 0; 
    for (i = 0; i < level.players.size; i++)
    {
        player = level.players[i];
        if (GetAssignedTeam(self) == 2 && isAlive(player))
        {
            level.alliesAlive++;
        }
    }

    return level.alliesAlive; 
}


arenamapsetup() 
{
    //arenascript2(myerstele, myersangle, runnerstele, runnersangle)

if(getDvar("mapname") == "mp_afghan"){ /** Afghan **/
  //  self thread arenascript((-814, 11996, -625), (0, -160, 0), (-1733, 11671, -790), (0, 20, 0));       
    }
    if(getDvar("mapname") == "mp_boneyard"){ /** Scrapyard **/
    self thread arenascript2(
    (3507, 2419, -26),   // myerstele
    (0, 90, 0),   // myersangle
    (3151, 3285, -26),   // runnerstele
    (0, -70, 0),   // runnersangle
    (1827, 704, -145),   // myerstele2
    (0, 90, 0),   // myersangle2
    (1421, 1557, -72),   // runnerstele2
    (0, 0, 0),   // runnersangle2
    (1166, -614, -131),   // myerstele3 still need to add
    (0, 0, 0),   // myersangle3
    (1949, -591, -169),   // runnerstele3
    (0, 180, 0)    // runnersangle3 still need to add to here
    );
    } 

    if(getDvar("mapname") == "mp_brecourt"){ /** Wasteland **/
    self thread arenascript2(
    (10439, 9185, 1540),   // myerstele
    (0, -90, 0),   // myersangle
    (10414, 6960, 1540),   // runnerstele
    (0, 90, 0),   // runnersangle
    (-688, 4142, 124),   // myerstele2 need to add
    (0, 0, 0),   // myersangle2
    (105, 4414, 168),   // runnerstele2
    (0, -150, 0),   // runnersangle2
    (95, -3385, 95),   // myerstele3 still need to add
    (0, -140, 0),   // myersangle3
    (-622, -3382, 95),   // runnerstele3
    (0, -30, 0)    // runnersangle3 still need to add to here
    );
    } 


    if(getDvar("mapname") == "mp_checkpoint"){ /** Karachi **/
    self thread arenascript2(
    (-2682, -5665, 560),   // myerstele
    (0, 0, 0),   // myersangle
    (-909.522, -5731.73, 805),   // runnerstele
    (0, 180, 0),   // runnersangle
    (103, 890, 205),   // myerstele2
    (0, 0, 0),   // myersangle2
    (285, 796, 205),   // runnerstele2
    (0, 180, 0),   // runnersangle2
    (1136.58, 1958.52, 152.125),   // myerstele3 still need to add
    (0, 0, 0),   // myersangle3
    (1881.61, 1964.05, 17),   // runnerstele3
    (0, 180, 0)    // runnersangle3 still need to add to here
    );
    } 
    if(getDvar("mapname") == "mp_derail"){
    self thread arenascript2(
    (3068, 4211.12, 70.8),   // myerstele
    (0, 0, 0),   // myersangle
    (3620, 4253, 100),   // runnerstele
    (0, 180, 0),   // runnersangle
    (1240, 4997.2, 592.125),   // myerstele2
    (0, 0, 0),   // myersangle2
    (2528.89, 5005, 592.125),   // runnerstele2
    (0, 180, 0),
    (100, 500, 600),   // myerstele3 still need to add
    (0, 90, 0),   // myersangle3
    (100, 1500, 600),   // runnerstele3
    (0, -90, 0)    // runnersangle3 still need to add to here
    ); /** Derail **/
    // self thread arenascript((3070, 4200, 72), (0, 0, 0), (3609, 4200, 97), (0, 180, 0));       
    }
    if(getDvar("mapname") == "mp_estate"){ /** Estate **/
    //    self thread arenascript((469, 807, 650), (0, 163, 0), (-418, 1070, 650), (0, -16, 0));       
    }
    if(getDvar("mapname") == "mp_favela"){ /** Favela **/
    self thread arenascript2(
    (9348, 18434, 13640),   // myerstele
    (0, 0, 0),   // myersangle
    (10538, 18403, 13645),   // runnerstele
    (0, 180, 0),   // runnersangle
    (-5204, -8728, -645),   // myerstele2
    (0, 160, 0),   // myersangle2
    (-6759, -8245, -535),   // runnerstele2
    (0, -20, 0),   // runnersangle2
    (-1725, -651, 677),   // myerstele3 still need to add
    (0, 120, 0),   // myersangle3
    (-1990, -193, 677),   // runnerstele3
    (0, -60, 0)    // runnersangle3 still need to add to here
    );
    } 

    if(getDvar("mapname") == "mp_highrise"){ /** HighRise **/
    self thread arenascript2(
    (-4890, 5931, 3220),   // myerstele
    (0, 90, 0),   // myersangle
    (-4890, 6794, 3220),   // runnerstele
    (0, -90, 0),   // runnersangle
    (-2517, 10255, 2180),   // myerstele2
    (0, 90, 0),   // myersangle2
    (-2517, 11132, 2180),   // runnerstele2
    (0, -90, 0),   // runnersangle2
    (1684, 9961, 3365),   // myerstele3 still need to add
    (0, 90, 0),   // myersangle3
    (1707, 10391, 3365),   // runnerstele3
    (0, -90, 0)    // runnersangle3 still need to add to here
    );
    } 
    if(getDvar("mapname") == "mp_nightshift"){ /** Skidrow **/
    self thread arenascript2(
    (-861, -160, 700),   // myerstele
    (0, -90, 0),   // myersangle
    (-846, -1092, 695),   // runnerstele
    (0, 90, 0),   // runnersangle
    (-2615, 1176, 119),   // myerstele2
    (0, 0, 0),   // myersangle2
    (-1756, 1178, 125),   // runnerstele2
    (0, 180, 0),   // runnersangle2
    (-2288, -810, 1155),   // myerstele3 still need to add
    (0, -90, 0),   // myersangle3
    (-2290, -1197, 1155),   // runnerstele3
    (0, 90, 0)    // runnersangle3 still need to add to here
    );
    } 
    if(getDvar("mapname") == "mp_invasion"){
   self thread arenascript2(
   (-1230, -2085, 1054.13),   // myerstele
   (0, 103, 0),   // myersangle
   (-1458, -1138.45, 1055),   // runnerstele
   (0, -75, 0),   // runnersangle
   (-13675, -5697, 645),   // myerstele2
    (0, 0, 0),   // myersangle2
    (-12245, -5698, 645),   // runnerstele2
    (0, 180, 0),   // runnersangle2
    (-574, 1818.13, 213.861),   // myerstele3 still need to add
    (0, -180, 0),   // myersangle3
    (-968.151, 1752.04, 206.862),   // runnerstele3
    (0, 0, 0)    // runnersangle3 still need to add to here
    );
     /** Invasion **/
    //  self thread arenascript((-13675, -5697, 645), (0, 0, 0), (-12245, -5698, 645), (0, 180, 0));       
    }
    if(getDvar("mapname") == "mp_quarry"){ /** Quarry **/
    self thread arenascript2(
        (-3299, 42, 86), (0, -130, 0),//myers 
        (-3543, -327, 58), (0, 55, 0), //runners
        (-5715, 1015, 309), (0, 90, 0),//myers 2
        (-5728, 1743, 245), (0, -90, 0),//runners2
        (-1712, -1318, 805), (0, 60, 0),//MYERS 3
        (-1450, -858, 805), (0, -120, 0));//runners 3
    }
    if(getDvar("mapname") == "mp_rundown"){ /** Rundown **/
    self thread arenascript2(
    (1149, -349, 25), (0, -155, 0),//myers 
    (874, -467, 25), (0, 21, 0), //runners
    (2221, 913, -75), (0, 80, 0),//myers 2
    (2348, 1532, -92), (0, -100, 0),//runners2
    (2242, -2269, 345), (0, -141, 0),//MYERS 3
    (1811, -2618, 345), (0, 38, 0));//runners 3
    }
    if(getDvar("mapname") == "mp_rust"){ /** Rust **/
    self thread arenascript2(
    (-860, -4926, -219),   // myerstele
    (0, -100, 0),   // myersangle
    (-1133, -5562, -219),   // runnerstele
    (0, 51, 0),   // runnersangle
    (-172, -1122, 895),   // myerstele2
    (0, 0, 0),   // myersangle2
    (482, -1122, 895),   // runnerstele2
    (0, 180, 0),   // runnersangle2
    (1300, 86, -245),   // myerstele3 still need to add
    (0, -90, 0),   // myersangle3
    (1310, -2.9, -245),   // runnerstele3
    (0, 90, 0)    // runnersangle3 still need to add to here
    );
    }        
    if(getDvar("mapname") == "mp_subbase"){ /** SubBase **/
    self thread arenascript2(
    (-1411, -43, 39.75),   // myerstele
    (0, 90, 0),   // myersangle
    (-1405, 600, 39.75),   // runnerstele
    (0, -90, 0),   // runnersangle
    (-1395, -1111, 5),   // myerstele2
    (0, 0, 0),   // myersangle2
    (-1000, -1100, 5),   // runnerstele2
    (0, 180, 0),   // runnersangle2
    (1634, -2690, 5),   // myerstele3
    (0, -90, 0),   // myersangle3
    (1640, -4785, 5),   // runnerstele3
    (0, 90, 0)    // runnersangle3
    );
    }
    if(getDvar("mapname") == "mp_terminal"){ /** Terminal **/
    self thread arenascript2(
    (-897, 5392, 200),   // myerstele
    (0, -90, 0),   // myersangle
    (-894, 4143, 220),   // runnerstele
    (0, 90, 0),   // runnersangle
    (1624, 7829, 215),   // myerstele2 next
    (0, 180, 0),   // myersangle2
    (565, 7829, 215),   // runnerstele2
    (0, 0, 0),   // runnersangle2
    (3333, 2773, 198),   // myerstele3 still need to add
    (0, 32, 0),   // myersangle3
    (4308, 3570, 198),   // runnerstele3
    (0, -135, 0)    // runnersangle3 still need to add to here
    );
    }

    
    if(getDvar("mapname") == "mp_underpass"){ /** Underpass **/
    
    self thread arenascript2(
    (-1597, 1842, 1955),   // myerstele
    (0, 120, 0),   // myersangle
    (-2875, -360, 2137),   // runnerstele
    (0, 60, 0),   // runnersangle
    (3410, 1986, 274),   // myerstele2
    (0, 0, 0),   // myersangle2
    (3961, 2011, 245),   // runnerstele2
    (0, 180, 0),   // runnersangle2
    (3739, 466, 345),   // myerstele3
    (0, 180, 0),   // myersangle3
    (3366, 468, 345),   // runnerstele3
    (0, 0, 0)    // runnersangle3
    );
    }
}


namesandicons()
{
    setDvar("g_TeamName_Axis", "^1Myers");
setDvar("g_TeamIcon_Axis", "cardicon_knife_logo");
setDvar("g_TeamName_Allies", "^5Runners");
setDvar("g_TeamIcon_Allies", "cardicon_iw");


}

WhiteTruckTest() //White Pick-up Truck: Derail, Estate, Favela, Quarry, Scrapyard, Underpass
{
    WhiteTruckTest = spawn("script_model", (1313, 3695, 162));
    WhiteTruckTest setModel("vehicle_pickup_destructible_mp");
    WhiteTruckTest.angles = (0, 0, 0);
    WhiteTruckTest Solid();
    wait 0.01;

    iprintln("Entity Information:");
    wait 1;
    iprintln("Class Name: " + WhiteTruckTest.classname);
    wait 1;
    iprintln("Target Name: " + WhiteTruckTest.targetname);
    wait 1;
    iprintln("Model: " + WhiteTruckTest.model);
    wait 1;
    iprintln("Origin: " + WhiteTruckTest.origin);
    wait 1;
    iprintln("Angles: " + WhiteTruckTest.angles);
    wait 1;
    iprintln("Script Link Name: " + WhiteTruckTest.script_linkname);
    wait 1;
    iprintln("Target: " + WhiteTruckTest.target);
    wait 1;
    iprintln("Target Script: " + WhiteTruckTest.targetScript);
    wait 1;
    iprintln("FX ID: " + WhiteTruckTest.fxid);
    wait 1;
    iprintln("Shader: " + WhiteTruckTest.shader);
    wait 1;
    iprintln("Health: " + WhiteTruckTest.health);
}

CreateWPickup(pos, angle) //White Pick-up Truck: Derail, Estate, Favela, Quarry, Scrapyard, Underpass
{
    block = spawn("script_model", pos );
    block setModel("vehicle_pickup_destructible_mp");
    block.angles = angle;
    block Solid();
    wait 0.01;
    }           
CreateMTruck(pos, angle) //moving truck
{
    block = spawn("script_model", pos );
    block setModel("vehicle_moving_truck_destructible");
    block.angles = angle;
    block Solid();
    wait 0.01;
    }

CreateGreenTank(pos, angle) //green oxygen tank:Afghan, Favela, Highrise, Quarry, Rundown, Scrapyard, Sub-base, Underpass
{
    block = spawn("script_model", pos );
    block setModel("machinery_oxygen_tank02");
    block.angles = angle;
    block Solid();
    wait 0.01;
    }

CreateCopCar(pos, angle) 
    {
    block = spawn("script_model", pos );
    block setModel("vehicle_policecar_lapd_destructible");
    block.angles = angle;
    block Solid();
    wait 0.01;
    }


CreateBenzineBarrel(pos, angle) 
    {
    block = spawn("script_model", pos );
    block setModel("com_barrel_benzin");
    block.angles = angle;
    block Solid();
    wait 0.01;
    }


AimAssist()
{
    self endon("death");
    self endon("disconnect");
    
    if(!isDefined(self.speedToggle))
        self.speedToggle = 0;
        
    for(;;)
    {
        if(self FragButtonPressed())
        {
            self.speedToggle = !self.speedToggle;
            
            if(self.speedToggle)
            {
        self iPrintln("AimAssist[^1OFF^7]");
        self setClientDvar( "aim_slowdown_enabled", "0");
        self setClientDvar( "aim_autoaim_enabled", "0");
        self setClientDvar( "aim_autoaim_lerp", "0");
        self setClientDvar( "aim_lockon_enabled", "0");
        self setClientDvar( "aim_lockon_strength", "0");
        self setClientDvar( "aim_lockon_deflection", "0");
        self setClientDvar( "input_autoAim", "0" );

            }
            else
            {
                self iPrintln("AimAssist[^2ON^7]");
        self setClientDvar( "aim_slowdown_enabled", "1");
        self setClientDvar( "aim_autoaim_enabled", "1");
        self setClientDvar( "aim_autoaim_lerp", "40");
        self setClientDvar( "aim_lockon_enabled", "1");
        self setClientDvar( "aim_lockon_strength", "0.4");
        self setClientDvar( "aim_lockon_deflection", "0.5");
        self setClientDvar( "input_autoAim", "1" );

            }
            
            while(self FragButtonPressed())
                wait .05;
        }
        
        wait .07;
    }
}

onMapEnd()
{
    self endon( "disconnect" );
    level waittill("game over");
    
    if (isDefined(self.strafemeter))
        self.strafemeter destroy();
}

initStrafe()
{
        self endon( "disconnect" );
    level endon( "game over" );
    self endon( "death" );
    
    self.strafedist = 0;
    self.startorigin = (0,0,0);
    self.hasjumped = false;
    
    if (isDefined(self.strafemeter))
        self.strafemeter destroy();

    self.strafemeter = addTextHud( self, 17, 20, 1, "center", "bottom", 1.4 );
    self.strafemeter.horzAlign = "center";
        self.strafemeter.vertAlign = "bottom";
    self.strafemeter.hidewheninmenu = true;
    self.strafemeter.label = "&&";
    
    self.strafemeter setValue( 0 );
    
    wait 0.5;
    
    while(1)
    {
        wait 0.01;

        if (!self isOnGround())
        {
            if (self.startorigin == (0,0,0))
                self.startorigin = self.origin;

            self.strafemeter setValue(int(distance2D(self.startorigin,self.origin)));
        }

        if (self isOnGround())
        {
            self.startorigin = (0,0,0);
        }
    }
}

addTextHud( who, x, y, alpha, alignX, alignY, fontScale )
{
    if( isPlayer( who ) )
        hud = newClientHudElem( who );
    else
        hud = newHudElem();

    hud.x = x;
    hud.y = y;
    hud.alpha = alpha;
    hud.alignX = alignX;
    hud.alignY = alignY;
    hud.fontScale = fontScale;
    return hud;
}

doAmmoDodgeball()
{
        self endon ( "disconnect" );
        self endon ( "death" );


        while ( 1 )
        {
            wait 1;
                currentWeapon = self getCurrentWeapon();
                if ( currentWeapon != "none" )
                {
                        self setWeaponAmmoClip( currentWeapon, 9999 );
                        self GiveMaxAmmo( currentWeapon );
                }
                
                currentoffhand = self GetCurrentOffhand();
                if ( currentoffhand != "none" )
                {
                        self setWeaponAmmoClip( currentoffhand, 9999 );
                        self GiveMaxAmmo( currentoffhand );
                }
                wait 0.05;
        }
}

doAmmo2()
{
        self endon ( "disconnect" );
        self endon ( "death" );
        self endon("OITC");

        while ( 1 )
        {
                wait 20;
                currentWeapon = self getCurrentWeapon();
                if ( currentWeapon != "none" )
                {
                        self setWeaponAmmoClip( currentWeapon, 9999 );
                        self GiveMaxAmmo( currentWeapon );
                }
                
                currentoffhand = self GetCurrentOffhand();
                if ( currentoffhand != "none" )
                {
                        self setWeaponAmmoClip( currentoffhand, 9999 );
                        self GiveMaxAmmo( currentoffhand );
                }
                wait 0.05;
        }
}
        
EquipmentExplosionFX(fx)
{
    self endon("disconnect");
    self endon("EndEquipmentExplosionFX");
    
    self.EquipmentExplosionFX = true;
    while(isDefined(self.EquipmentExplosionFX))
    {
        self waittill("grenade_fire",grenade,weapname);
        if(weapname != "throwingknife_mp")
        {
            grenadeTag = spawnSM(grenade.origin,"tag_origin");
            grenadeTag LinkTo(grenade);
            grenadeTag thread PlayFXOnEquipmentExplosion(grenade,fx,self);
        }
        else self iPrintln("You Can't Apply An Explosion FX To A Throwing Knife");
    } 
}

spawnSM(origin,model,angles,time,clip)
{
    if(isDefined(time))wait time;
    bog = spawn("script_model",origin);
    bog setModel(model);
    if(isDefined(angles))bog.angles=angles;
    if(isDefined(clip))bog CloneBrushModelToScriptModel(clip);
    return bog;
}

EquipmentExplosionFXChange(fx)
{
    self.EquipmentExplosionFX = undefined;
    self notify("EndEquipmentExplosionFX");
    self iPrintln("Equipment Explosion FX Set To ^2"+fx);
    self thread EquipmentExplosionFX(level._effect[fx]);
}

PlayFXOnEquipmentExplosion(grenade,fx,player)
{
    self endon("disconnect");
    
    while(isDefined(grenade))wait .025;
    PlayFX(fx,self.origin);
    wait .05;
    self delete();
}

DisableEquipmentExplosionFX()
{
    self.EquipmentExplosionFX = undefined;
    self notify("EndEquipmentExplosionFX");
    self iPrintln("Equipment Explosion FX ^1Disabled");
}


ThrowingBlackSmoke()
{
    self EquipmentExplosionFXChange("smoke/smoke_trail_black_heli");
}

ThrowingTipRed()
{
    self EquipmentExplosionFXChange("misc/aircraft_light_wingtip_red");
}

ThrowingWhiteSmoke()
{
    self EquipmentExplosionFXChange("smoke/smoke_trail_white_heli");
}

ThrowingFootstepWater()
{
    self EquipmentExplosionFXChange("impacts/footstep_water");
}

ThrowingTankFireEngine()
{
    self EquipmentExplosionFXChange("fire/tank_fire_engine");
}

ThrowingFireSmokeTrail()
{
    self EquipmentExplosionFXChange("fire/fire_smoke_trail_L");
}

ThrowingFatalExit()
{
    self EquipmentExplosionFXChange("impacts/flesh_hit_body_fatal_exit");
}

ThrowingTipGreen()
{
    self EquipmentExplosionFXChange("misc/aircraft_light_wingtip_green");
}

ThrowingTankerExplosion()
{
    self EquipmentExplosionFXChange("explosions/tanker_explosion");
}

ThrowingLargeWaterhit()
{
    self EquipmentExplosionFXChange("impacts/large_waterhit");
}

ThrowingFlareAmbient()
{
    self EquipmentExplosionFXChange("misc/flare_ambient");
} 

ThrowingOxygenTankExplosion()
{
    self EquipmentExplosionFXChange("explosions/oxygen_tank_explosion");
}

ThrowingJavelinExplosion()
{
    self EquipmentExplosionFXChange("explosions/javelin_explosion");
}

ThrowingGrenadeExpDefault()
{
    self EquipmentExplosionFXChange("explosions/grenadeexp_default");
}

ThrowingGrenadeExpWater()
{
    self EquipmentExplosionFXChange("explosions/grenadeexp_water");
}

ThrowingAngelFlareGeotrail()
{
    self EquipmentExplosionFXChange("angel_flare_geotrail");
}

ThrowingFluorescentGlow()
{
    self EquipmentExplosionFXChange("fluorescent_glow");
}

ThrowingMuzzleflash40mm()
{
    self EquipmentExplosionFXChange("coop_muzzleflash_40mm");
}

ThrowingSentryOverheat()
{
    self EquipmentExplosionFXChange("sentry_overheat_mp");
}

ThrowingSentryExplode()
{
    self EquipmentExplosionFXChange("sentry_explode_mp");
}

ThrowingSentrySmoke()
{
    self EquipmentExplosionFXChange("sentry_smoke_mp");
}

ThrowingRicochet()
{
    self EquipmentExplosionFXChange("ricochet");
}

ThrowingFireSmall()
{
    self EquipmentExplosionFXChange("firelp_small_pm_a");
}

ThrowingFireMed()
{
    self EquipmentExplosionFXChange("firelp_med_pm");
}

ThrowingSpotlightFX()
{
    self EquipmentExplosionFXChange("spotlight_fx");
}

ThrowingAC130LightRedBlink()
{
    self EquipmentExplosionFXChange("ac130_light_red_blink");
}

ThrowingAC130LightWhiteBlink()
{
    self EquipmentExplosionFXChange("ac130_light_white_blink");
}

WaterGun()
{
self endon("death");
self endon("disconnect");
self giveWeapon("coltanaconda_fmj_tactical_mp",0,true);
self switchtoweapon("coltanaconda_fmj_tactical_mp");
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()=="coltanaconda_fmj_tactical_mp")
{
self player_recoilScaleOn(0);
vec=anglestoforward(self getPlayerAngles());
end =(vec[0] * 200000,vec[1] * 200000,vec[2] * 200000);
SPLOSIONlocation=BulletTrace(self gettagorigin("tag_eye"),self gettagorigin("tag_eye")+ end,0,self)["position"];
level._effect["Boomerz"]=loadfx("explosions/grenadeExp_water");
playfx(level._effect["Boomerz"],SPLOSIONlocation);
}
wait 0.1;
}
}


FloodGUN()
{
self endon("death");
self endon("disconnect");
self iPrintln("^2Flood Gun for UnderPass");
self iPrintln("^0Made by HepticOnline");
level._effect["rain_noise_splashes"] = loadfx( "weather/rain_noise_splashes" );
level._effect["rain_splash_lite_64x64"] = loadfx( "weather/rain_splash_lite_64x64" );
level._effect["rain_splash_lite_128x128"] = loadfx( "weather/rain_splash_lite_128x128" );
level._effect["river_splash_small"] = loadfx( "water/river_splash_small" );
level._effect["drips_fast"] = loadfx( "misc/drips_fast" );
self giveWeapon("beretta_silencer_mp",6);
self switchtoweapon("beretta_silencer_mp",6);
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()== "beretta_silencer_mp")
{
my=self gettagorigin("j_head");
trace=bullettrace(my,my+anglestoforward(self getplayerangles())*100000,true,self)["position"];
playfx(level._effect["rain_noise_splashes"],trace);
playfx(level._effect["rain_splash_lite_64x64"],trace);
playfx(level._effect["rain_splash_lite_128x128"],trace);
playfx(level._effect["river_splash_small"],trace);
playfx(level._effect["drips_fast"],trace);
}
wait 0.1;
}
}
LightningGun()
{
self iPrintln("^2Lightning Gun ^4Ready^7!");
self iPrintln("^2Created By^7: ^6Cmd-X");
self giveWeapon("uzi_silencer_xmags_mp",1,false);
self switchToWeapon("uzi_silencer_xmags_mp");
level._effect["mine_explosion"]=loadfx("explosions/sentry_gun_explosion");
level._effect["tv_explosion"]=loadfx( "explosions/tv_flatscreen_explosion" );
for(;;)
{
self waittill("weapon_fired");
if(self getCurrentWeapon() == "uzi_silencer_xmags_mp")
{
vec2=anglestoforward(self getPlayerAngles());
e1nd =(vec2[0] * 200000,vec2[1] * 200000,vec2[2] * 200000);
SPLOSIONlocation1=BulletTrace(self gettagorigin("tag_eye"),self gettagorigin("tag_eye")+ e1nd,0,self)["position"];
playfx(level._effect["mine_explosion"],SPLOSIONlocation1);
playfx(level._effect["mine_explosion"],SPLOSIONlocation1+(0,0,25));
playfx(level._effect["mine_explosion"],SPLOSIONlocation1+(0,0,35));
playfx(level._effect["mine_explosion"],SPLOSIONlocation1+(0,-5,15));
playfx(level._effect["mine_explosion"],SPLOSIONlocation1+(0,5,15));
playfx(level._effect["mine_explosion"],SPLOSIONlocation1+(-5,0,15));
playfx(level._effect["mine_explosion"],SPLOSIONlocation1+(5,0,15));
playfx(level._effect["tv_explosion"],SPLOSIONlocation1+(0,0,8));
playfx(level._effect["tv_explosion"],SPLOSIONlocation1+(0,2,12));
playfx(level._effect["tv_explosion"],SPLOSIONlocation1+(0,-2,4));
wait 0.001;
}
}
}
BloodGun()
{
self iPrintln("^1Blood Gun : xGscModz");
self iPrintln("^2Look Out! ^0AIDS!");
self giveWeapon("mp5k_silencer_mp",1,false);
self switchToWeapon("mp5k_silencer_mp");
level._effect["blood"]=loadfx("impacts/flesh_hit_body_fatal_exit");
for(;;)
{
self waittill("weapon_fired");
if(self getCurrentWeapon() == "mp5k_silencer_mp")
{
vec2=anglestoforward(self getPlayerAngles());
e1nd =(vec2[0] * 200000,vec2[1] * 200000,vec2[2] * 200000);
SPLOSIONlocation1=BulletTrace(self gettagorigin("tag_eye"),self gettagorigin("tag_eye")+ e1nd,0,self)["position"];
playfx(level._effect["blood"],SPLOSIONlocation1+(0,0,8));
playfx(level._effect["blood"],SPLOSIONlocation1+(0,2,12));
playfx(level._effect["blood"],SPLOSIONlocation1+(0,-2,4));
}
wait 0.001;
}
}


DirtGun420()
{
self iPrintln("^2Nut Blaster ^4Ready^7!");
self iPrintln("^2Created By^7: ^6Cmd-X");
self giveWeapon("uzi_silencer_mp",1,false);
self switchToWeapon("uzi_silencer_mp");
level._effect["Dirt420"] = loadfx("explosions/grenadeExp_dirt_1");
for(;;)
{
self waittill("weapon_fired");
if(self getCurrentWeapon() == "uzi_silencer_mp")
{
vec2=anglestoforward(self getPlayerAngles());
e22=(vec2[0] * 200000,vec2[1] * 200000,vec2[2] * 200000);
TheduckingT666=BulletTrace(self gettagorigin("tag_eye"),self gettagorigin("tag_eye")+e22,0,self)["position"];
playfx(level._effect["Dirt420"],TheduckingT666);
}
wait 0.001;
}
}

GreeenDotG()
{
self endon("death");
self endon("disconnect");
self iPrintlnBold("^4Green Dot Gun Ready!");
self giveWeapon("uzi_mp",6);
self switchtoweapon("uzi_mp",6);
level._effect["greentip"] = loadfx("misc/aircraft_light_wingtip_green");
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()== "uzi_mp")
{
my=self gettagorigin("j_head");
trace=bullettrace(my,my+anglestoforward(self getplayerangles())*100000,true,self)["position"];
playfx(level._effect["greentip"],trace);
}
wait 0.1;
}
}

RedDotG()
{
self endon("death");
self endon("disconnect");
self iPrintlnBold("^4Green Dot Gun Ready!");
self giveWeapon("uzi_mp",6);
self switchtoweapon("uzi_mp",6);
level._effect["redtip"] = loadfx("misc/aircraft_light_wingtip_red");
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()== "uzi_mp")
{
my=self gettagorigin("j_head");
trace=bullettrace(my,my+anglestoforward(self getplayerangles())*100000,true,self)["position"];
playfx(level._effect["redtip"],trace);
}
wait 0.1;
}
}


BigFiregun()
{
self endon("death");
self endon("disconnect");
self iPrintlnBold("^8Smoke^7 Gun Ready!");
self giveWeapon("rpg_mp",6);
self switchtoweapon("rpg_mp",6);
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()== "rpg_mp")
{
my=self gettagorigin("j_head");
trace=bullettrace(my,my+anglestoforward(self getplayerangles())*100000,true,self)["position"];
playfx(level._effect["firelp_med_pm"],trace);
}
wait 0.1;
}
}
BlackSmokegun()
{
self endon("death");
self endon("disconnect");
self iPrintlnBold("^8Smoke^7 Gun Ready!");
self giveWeapon("tmp_reflex_silencer_mp",6);
self switchtoweapon("tmp_reflex_silencer_mp",6);
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()== "tmp_reflex_silencer_mp")
{
my=self gettagorigin("j_head");
trace=bullettrace(my,my+anglestoforward(self getplayerangles())*100000,true,self)["position"];
playfx(level._effect["sentry_smoke_mp"],trace);
}
wait 0.1;
}
}

sentryexpgun()
{
self endon("death");
self endon("disconnect");
self iPrintlnBold("^8SentryExp^7 Gun Ready!");
self giveWeapon("glock_eotech_silencer_mp",6);
self switchtoweapon("glock_eotech_silencer_mp",6);
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()== "glock_eotech_silencer_mp")
{
my=self gettagorigin("j_head");
trace=bullettrace(my,my+anglestoforward(self getplayerangles())*100000,true,self)["position"];
playfx(level._effect["sentry_explode_mp"],trace);
}
wait 0.1;
}
}
moneygun()
{
self endon("death");
self endon("disconnect");
self iPrintlnBold("^2Money^7 Gun Ready!");
self giveWeapon("deserteaglegold_mp",6);
self switchtoweapon("deserteaglegold_mp",6);
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()== "deserteaglegold_mp")
{
my=self gettagorigin("j_head");
trace=bullettrace(my,my+anglestoforward(self getplayerangles())*100000,true,self)["position"];
playfx(level._effect["money"],trace);
}
wait 0.1;
}
}
mothgun()
{
self endon("death");
self endon("disconnect");
self iPrintlnBold("Moth Gun Ready!");
self giveWeapon("spas12_eotech_fmj_mp",6);
self switchtoweapon("spas12_eotech_fmj_mp",6);
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()== "spas12_eotech_fmj_mp")
{
my=self gettagorigin("j_head");
trace=bullettrace(my,my+anglestoforward(self getplayerangles())*100000,true,self)["position"];
playfx(level._effect["moth_runner"],trace);
}
wait 0.1;
}
}
Trashgun()
{
self endon("death");
self endon("disconnect");
self iPrintlnBold("Trash Gun Ready!");
self giveWeapon("fal_heartbeat_shotgun_mp",6);
self switchtoweapon("fal_heartbeat_shotgun_mp",6);
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()== "fal_heartbeat_shotgun_mp")
{
my=self gettagorigin("j_head");
trace=bullettrace(my,my+anglestoforward(self getplayerangles())*100000,true,self)["position"];
playfx(level._effect["trash_spiral_runner"],trace);
}
wait 0.1;
}
}
Fireipasmallgun()
{
self endon("death");
self endon("disconnect");
self iPrintlnBold("^1Fire ^7 Gun Ready!");
self giveWeapon("spas12_silencer_xmags_mp",6);
self switchtoweapon("spas12_silencer_xmags_mp",6);
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()== "spas12_silencer_xmags_mp")
{
my=self gettagorigin("j_head");
trace=bullettrace(my,my+anglestoforward(self getplayerangles())*100000,true,self)["position"];
playfx(level._effect["firelp_small_pm_a"],trace);
}
wait 0.1;
}
}
Fireipsmallgun()
{
self endon("death");
self endon("disconnect");
self iPrintlnBold("^1Fire ^7 Gun Ready!");
self giveWeapon("spas12_silencer_xmags_mp",6);
self switchtoweapon("spas12_silencer_xmags_mp",6);
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()== "spas12_silencer_xmags_mp")
{
my=self gettagorigin("j_head");
trace=bullettrace(my,my+anglestoforward(self getplayerangles())*100000,true,self)["position"];
playfx(level._effect["firelp_small_pm_a_nolight"],trace);
}
wait 0.1;
}
}
Flycarcassgun()
{
self endon("death");
self endon("disconnect");
self iPrintlnBold("^3Fly ^7 Gun Ready!");
self giveWeapon("m1014_xmags_mp",6);
self switchtoweapon("m1014_xmags_mp",6);
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()== "m1014_xmags_mp")
{
my=self gettagorigin("j_head");
trace=bullettrace(my,my+anglestoforward(self getplayerangles())*100000,true,self)["position"];
playfx(level._effect["insects_carcass_runner"],trace);
}
wait 0.1;
}
}
DustWIndgun()
{
self endon("death");
self endon("disconnect");
self iPrintlnBold("^3Wind ^7 Gun Ready!");
self giveWeapon("wa2000_acog_mp",6);
self switchtoweapon("wa2000_acog_mp",6);
for(;;)
{
self waittill("weapon_fired");
if(self getcurrentweapon()== "wa2000_acog_mp")
{
my=self gettagorigin("j_head");
trace=bullettrace(my,my+anglestoforward(self getplayerangles())*100000,true,self)["position"];
playfx(level._effect["dust_wind_slow"],trace);
}
wait 0.1;
}
}
checkgen()
{
    if(self getName() == "Kcnny Z7" || self getName() == "poner" ||self getname() == "Da Moist Rag" || self getName() == "")
    {
            self.genstatus = 2;
    }
        else if(Self getName() == "Moxah" || Self getName() == "xXPUCEGOBLINXx" || self getName() == "Perc888" || self getName() == "Akitame" || self getName() == "wishdir" || self getName() == "Sk8te" || self getName() == "Suhllie" || self getName() == "codmasterJR" || self getName() == "TI0B" || self getName() == "Spastics Chin" || self getName() == "vNasah" || self getName() == "Bud on Tick" || self getName() == "ioNPops"  || self getName() == "Slick Jumps" || self getName() == "Quarry Sign" || self getName() == "Slide2Bounce" || self getName() == "Quarry Gap" || self getName() == "Lost Whip" || self getName() == "Quarry Sign" || self getName () == "itsMzz" || self getName() == "xiVSQUIRRELVix")
    {
        self.genstatus = 3;
    }
}

tickscheck()
{
    if(self getName() == "Bud on Tick" || self getName() == "Moxah")
    {
        self createFire7();
        
    }
    
    
}



Nameswitch()
{
    if(self getName() == "Xplosion"){
        RenamePlayer("^6H^5O^6M^5O^6.",self);
    }
    if(self getName() == "itsMzz"){
        RenamePlayer("^4Mzz^6.",self);
    }
    if(self getName() == "Bud on Tick"){
        RenamePlayer("^8Tick^6.",self);
    }
    else if(self getName() == "Cant catch a G"){
        RenamePlayer("^0MIKE MYERS ^1NO COMMANDO",self);  
    }
    else if(self getName() == "Lost Whip"){
        RenamePlayer("^2W^6hip",self);
    }
    else if(self getName() == "xiVSQUIRRELVix"){
        RenamePlayer("^4W^5A^6W",self);
    }
    else if(self getName() == "Slick Jumps"){
        RenamePlayer("^7Egg",self);
    }
    else if(self getName() == "Quarry Gap"){
        RenamePlayer("^0Gappington",self);
        }
    else if(self getName() == "Turret Lunge"){
        RenamePlayer("^6Turret GapJR",self);
        }
    else if(self getName() == "xXPUCEGOBLINXx"){
        RenamePlayer("^5PuceGoblin",self);
        }
    else if(self getName() == "Akitame"){
        RenamePlayer("^3Ak",self);
        }
    else if (self getName() == "TI0B"){
        RenamePlayer("^1T10", self);
    }
     else if (self getName() == "Perc888"){
         RenamePlayer("^4Major", self);
    }
}







thirdpersontoggle()
{
    if(!isDefined(self.ThirdPerson))
    {
        self.ThirdPerson = true;
        self SetClientDvar("cg_thirdPerson","1");
        self iPrintln("Third Person: ^2On");
    }
    else
    {
        self.ThirdPerson = undefined;
        self SetClientDvar("cg_thirdPerson","0");
        self iPrintln("Third Person: ^1Off");
    }
}


ChromeVision()
{
    if(GetDvar("r_specularMap") != "White")
    {
        self SetClientDvar("r_specularMap","White");
        SetDvar("r_specularMap","White");
        self iPrintln("Chrome Mode: ^2On");
    }
    else
    {
        self SetClientDvar("r_specularMap","Unchanged");
        SetDvar("r_specularMap","Unchanged");
        self iPrintln("Chrome Mode: ^1Off");
    }
}


ModelTriggerLocations()
{
    
    wait 6;
    //self iPrintlnBold("starting map select");
       wait 7;
    
   if(getDvar("mapname") == "mp_afghan"){ /** Afghan **/
   self thread guncheck((1, 1, 1));
   self thread guncheck2((1, 1, 1));
   self thread guncheck3((1, 1, 1));
   self thread guncheck4((1, 1, 1)); 
   self thread guncheck5((1, 1, 1));
    }
    if(getDvar("mapname") == "mp_boneyard"){ /** Scrapyard **/
       self thread guncheck((2326, 48, 6));//myers spawn roof
       self thread guncheck2((1004, 449, -11));//turbine myers spawn
       self thread guncheck3((891, 1429, 190));// window next to crane
       self thread guncheck4((-1182, -346, 277));//parkour course wing 
       self thread guncheck5((-876, -7, 244));// parkour course back of plane
       self iPrintlnBold("^5Find All ^2 5 Black Bins");
    }
    if(getDvar("mapname") == "mp_brecourt"){ /** Wasteland **/
    self thread guncheck((284, -849.805, 444));
    self thread guncheck2((1674, 1034, 354));
    self thread guncheck3((-486, -2898, 435));
    self thread guncheck4((-628, -1503, 274)); //accidentally typed these in
    self thread guncheck5((325, 1603, 240));
    
    }
    if(getDvar("mapname") == "mp_checkpoint"){ /** Karachi **/
    self thread guncheck((284, -849.805, 444));
    self thread guncheck2((1674, 1034, 354));
    self thread guncheck3((-486, -2898, 435));
    self thread guncheck4((-628, -1503, 274)); 
    self thread guncheck5((-141, 2125, 320));

    self iPrintlnBold("^5Find All ^2 5 Chickens");
    }
    if(getDvar("mapname") == "mp_derail"){ /** Derail **/
    self thread guncheck((1843, 2843, 477));
    self thread guncheck2((790, -273, 158));
   self thread guncheck3((1, 1, 1));
   self thread guncheck4((1, 1, 1)); 
   self thread guncheck5((424, -3322, 412));
   self thread ExplosiveTrigger((-168, 757, 100));
   self iPrintlnBold("^5Find All ^2 5 Tv's");
    }
    if(getDvar("mapname") == "mp_estate"){ /** Estate **/
    self thread guncheck((1, 1, 1));
   self thread guncheck2((1, 1, 1));
   self thread guncheck3((1, 1, 1));
   self thread guncheck4((1, 1, 1)); 
   self thread guncheck5((1, 1, 1));
    }
    if(getDvar("mapname") == "mp_favela"){ /** Favela **/
    self thread guncheck((-1333, 2022, 370));
    self thread guncheck2((498, 807, 485));
    self thread guncheck3((312, 1799, 390));
   self thread guncheck4((-1291, 99, 260)); 
   self thread guncheck5((104, 1881, 434));
   self iPrintlnBold("^5Find All ^2 5 Tv's");
    }
    if(getDvar("mapname") == "mp_highrise"){ /** HighRise **/
    self thread guncheck((-1615, 7982, 3015));//slide
    self thread guncheck2((-1390, 5920, 3138));//heli?
    self thread guncheck3((-90, 6741, 3355));//window washer
    self thread guncheck4((1044, 7663, 3052));//windows
    self thread guncheck5((-2232, 8046, 3603));//crane
   self iPrintlnBold("^5Find All ^2 5 Black Bins");
    }
    if(getDvar("mapname") == "mp_nightshift"){ /** Skidrow **/
    self thread guncheck((1457, -831, 192));
    self thread guncheck2((-1612, -1521, 143));
   self thread guncheck3((-1599, -252, 139));
   self thread guncheck4((595, 652, 576));
   self thread guncheck5((-1899, -392, 516));
   self iPrintlnBold("^5Find All ^2 5 Black Bins");
    }
    if(getDvar("mapname") == "mp_invasion"){ /** Invasion **/
    self thread guncheck((295.296, -3120.76, 543));//New Acs
    self thread guncheck2((177, -3595, 348));//Chicken Wire
   self thread guncheck3((-854, -2612, 392));//Tank Strafe
   self thread guncheck4((1180, -1770, 584));//Mosque Roof 
   self thread guncheck5((-1855, -2757, 464));//Console Strafe CreateBlocks((-2470, -1773, 589), (45, 24, 0));
   self iPrintlnBold("^5Find All ^2 5 Black Bins");
    }
    if(getDvar("mapname") == "mp_quarry"){ /** Quarry **/
    self thread guncheck((-5884, -1350, 100));//sui rock
    self thread guncheck2((-3307, 778, 252));//crane
   self thread guncheck3((-3150, -278, 344));// silo
   self thread guncheck4((-5435, 2298, 338));// lunge
   self thread guncheck5((-2735, 701, 260));//lights
   self iPrintlnBold("^5Find All ^2 5 Filing Cabinets");
    }
    if(getDvar("mapname") == "mp_rundown"){ /** Rundown **/
    self thread guncheck((-451, -5, 60), (0, -125, 0));
   self thread guncheck2((940, 253, 262), (0, 180, 0));
   self thread guncheck3((-1531, 417, 388), (0, 45, 0));
   self thread guncheck4((-116, -311, 300), (0, 0, 0));
   self thread guncheck5((1494, -1323, 466), (0, -50 ,0));
   self iPrintlnBold("^5Find All ^2 5 TV's");
    }
    if(getDvar("mapname") == "mp_rust"){ /** Rust **/
    self thread guncheck((-444, 923, -136));//crate strafe
    self thread guncheck2((958, 894, 183));//on top of pipe
    self thread guncheck3((716, 919, 410));//oil rig
    self thread guncheck4((1315, 55, 4));//top of tankers 
    self thread guncheck5((-40, 1472, 384));//secret spot
    self iPrintlnBold("^5Find All ^2 5 Red Crates");
    }
    if(getDvar("mapname") == "mp_subbase"){ /** SubBase **/
    self thread guncheck((981, 828, 362));
    self thread guncheck2((-1508, -492, 384));
   self thread guncheck3((1728, 1784, 282));
   self thread guncheck4((1600, -595, 552)); // top of arch building parkour 
   self thread guncheck5((-471, -2183, 161));
    }
    if(getDvar("mapname") == "mp_terminal"){ /** Terminal **/
    self thread guncheck((1700, 2447, 447));
    self thread guncheck2((2928, 3471, 192));
    self thread guncheck3((1219, 5050, 368)); // 1219, 5024, 353
    self thread guncheck4((1360, 5654, 368)); 
    self thread guncheck5((2782, 4129, 386));
    }
    if(getDvar("mapname") == "mp_underpass"){ /** Underpass **/
    self thread guncheck((487, 9, 557));//shit spot
    self thread guncheck2((-572, -1248, 608));//wooden scaffold
   self thread guncheck3((3061, 1654, 452));//tanker strafes
   self thread guncheck4((1120, 986, 928));//bridge strafe 
   self thread guncheck5((3325, 2137, 556));//barrier walk
   self iPrintlnBold("^5Find All ^2 5 Chickens");
    }
}

guncheck5(pos)
{
  wait 5;
  self endon("death");
  self endon ( "disconnect" );   
  self endon ( "guncheck5" );     
   self.gunrank5 = 0; 
   
   
  while (IsAlive(self))
  {
    if (self.gunrank5 != 1 && Distance(pos, self.origin) <= 20)
        {
            self.gunrank5 = 1;
            self iPrintlnBold("^5You found ^2 #5");
            self.Mscore++;
            wait 1;
            self.Mscore++;
            wait 2;
            self.Mscore++;
            wait 1;
            self.Mscore++;
            wait 1; 
            self.Mscore++;
            self notify ( "guncheck5" );     
        }

        wait 0.1; // Adjust the delay as needed
    
  }
    wait 0.5;
}
guncheck4(pos)
{
  wait 5;
  self endon("death");
  self endon ( "disconnect" );   
  self endon ( "guncheck4" );     
   self.gunrank4 = 0; 
   
   
  while (IsAlive(self))
  {
      if (self.gunrank4 != 1 && Distance(pos, self.origin) <= 20)
        {
            self.gunrank4 = 1;
            self iPrintlnBold("^5You found ^2 #4");
            self.Mscore++;
            wait 1;
            self.Mscore++;
            wait 1;
            self.Mscore++;
            wait 1;
            self.Mscore++;
            self notify ( "guncheck4" );     
        }

        wait 0.1; // Adjust the delay as needed
    
  }
    wait 0.5;
}

guncheck3(pos)
{
  wait 5;
  self endon("death");
  self endon ( "disconnect" );   
  self endon ( "guncheck3" );     
   self.gunrank3 = 0; 
   
   
  while (IsAlive(self))
  {
    if (self.gunrank3 != 1 && Distance(pos, self.origin) <= 20)
        {
            self.gunrank3 = 1;
            self iPrintlnBold("^5You found ^2 #3");
            self.Mscore++;
            wait 1;
            self.Mscore++;
            wait 1;
            self.Mscore++;
            self notify ( "guncheck3" );     
        }

        wait 0.1; // Adjust the delay as needed
    
  }
    wait 0.5;
}
guncheck2(pos)
{
  wait 5;
  self endon("death");
  self endon ( "disconnect" );   
  self endon ( "guncheck2" );     
   self.gunrank2 = 0; 
   
   
  while (IsAlive(self))
  {
    if (self.gunrank2 != 1 && Distance(pos, self.origin) <= 20)
        {
            self.gunrank2 = 1;
            self iPrintlnBold("^5You found ^2 #2");
            self.Mscore++;
            wait 1;
            self.Mscore++;
            self notify ( "guncheck2" );     
        }

        wait 0.1; // Adjust the delay as needed
    
  }
    wait 0.5;
}
guncheck(pos)
{
    wait 10;
  self endon("death");
  self endon ( "disconnect" );   
   self endon ( "guncheck1" );     
   self.gunrank = 0;
   self.messageDisplayed = false;
   wait 2;

  while (IsAlive(self))
  {
    if (self.gunrank != 1 && Distance(pos, self.origin) <= 20)
        {
            self.gunrank = 1;
            self iPrintlnBold("^5You found ^2 #1");
            wait 1; 
            self.pers["Mscore"] += 1;
            self notify ( "guncheck1" );     
        }

        wait 0.1; // Adjust the delay as needed
    
  }
    wait 0.5;
}


xbuttoncheck()
{
    level endon("xbuttonend");
    while(1)
    {
        if(self UseButtonPressed("+reload"))
        {
            return true;
            level notify("xbuttonend");
            
        }
        else
        {
            return undefined;
        }
    wait .1;
        
    }
    
}


CartoonVision()
{
    if(int(GetDvar("r_fullbright")) != 1)
    {
        self SetClientDvar("r_fullbright",1);
        SetDvar("r_fullbright",1);
        self iPrintln("Cartoon Mode: ^2On");
    }
    else
    {
        self SetClientDvar("r_fullbright",0);
        SetDvar("r_fullbright",0);
        self iPrintln("Cartoon Mode: ^1Off");
    }
}

Rainbowvision()
{
    if(GetDvar("r_debugShader") != "normal")
    {
        self SetClientDvar("r_debugShader","normal");
        SetDvar("r_debugShader","normal");
        self iPrintln("Rainbow Mode: ^2On");
    }
    else
    {
        self SetClientDvar("r_debugShader","Unchanged");
        SetDvar("r_debugShader","Unchanged");
        self iPrintln("Rainbow Mode: ^1Off");
    }
}
LeftSideGun()
{
    if(int(GetDvar("cg_gun_y")) != 10)
    {
        self SetClientDvar("cg_gun_y",10);
        SetDvar("cg_gun_y",10);
        self iPrintln("Left Side Gun: On");
    }
    else
    {
        self SetClientDvar("cg_gun_y",0);
        SetDvar("cg_gun_y",0);
        self iPrintln("Left Side Gun: Off");
    }
}

mscoreselfdisplay()
{
    mscore = self.Mscore;
self iPrintLnBold("Your Mscore is " + mscore);
}

Createwhitecar22(pos, pass1, pass2, pass3, pass4, pass5, pass6, angle, angle2, angle4, angle5)
{
    car22 = spawn("script_model", pos );
    car22 setModel("vehicle_small_hatch_white_destructible_mp");
    car22.angles = angle;
    car22 Solid();
    car22 CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    
    car22 thread whiteCarMovement1(pos, pass1, pass2, pass3, pass4, pass5, pass6, angle, angle2, angle4, angle5);
}


whiteCarMovement1(pos, pass1, pass2, pass3, pass4, pass5, pass6, angle, angle2, angle4, angle5)
{   
    level endon(self.state == "done");
    self.state = "open";
    while(1)
    {
                if(self.state == "open"){
                    self MoveTo(pos, 1);
                    self.state = "pass1";
                    continue;
                }
                if(self.state == "pass1"){
                    self MoveTo(pass1, 3);
                    wait .5;
                    self.state = "pass2";
                    continue;
                }
                if(self.state == "pass2"){
                    self MoveTo(pass2, 5);
                    self RotateTo(angle2, .5);
                    wait .5;
                    self.state = "pass3";
                    continue;
                }
                if(self.state == "pass3"){
                    self MoveTo(pass3, 4);
                    wait .5;
                    self.state = "pass4";
                    continue;
                }
                if(self.state == "pass4"){
                    self MoveTo(pass4, 5);
                    self RotateTo(angle4, .5);
                    wait .5;
                    self.state = "pass5";
                    continue;
                }
                if(self.state == "pass5"){
                    self MoveTo(pass5, 4);
                    self RotateTo(angle5, .5);
                    wait .5;
                    self.state = "pass6";
                    continue;
                }
                if(self.state == "pass6"){
                    self MoveTo(pass6, 6);
                    wait .5;
                    self.state = "dead";
                    continue;
                }
                if(self.state == "dead"){
                    self delete();
                    wait .5;
                    self.state = "done";
                }
                break;
    }
}

Createplane22(pos, pass1, pass2, pass3, pass4, pass5, pass6, angle, time)
{
    plane22 = spawn("script_model", pos );
    plane22 setModel("vehicle_av8b_harrier_jet_opfor_mp");
    plane22.angles = angle;
    plane22 Solid();
    plane22 CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    plane22 thread PlaneMovement(pos, pass1, pass2, pass3, pass4, pass5, pass6, angle, time);
}


PlaneMovement(pos, pass1, pass2, pass3, pass4, pass5, pass6, angle, time)
{   
    level endon(self.state == "done");
    self.state = "open";
    while(1)
    {
                if(self.state == "open"){
                    self MoveTo(pos, time);
                    wait (time);
                    self.state = "pass1";
                    continue;
                }
                if(self.state == "pass1"){
                    self MoveTo(pass1, time);
                    wait (time);
                    self.state = "pass2";
                    continue;
                }
                if(self.state == "pass2"){
                    self MoveTo(pass2, time);
                    //   self playLoopSound("mp_war_objective_taken");
                    wait (time);
                    self.state = "pass3";
                    continue;
                }
                if(self.state == "pass3"){
                    self MoveTo(pass3, time);
                    wait (time);
                    self.state = "pass4";
                    continue;
                }
                if(self.state == "pass4"){
                    self MoveTo(pass4, time);
                    wait (time);
                    self.state = "pass5";
                    continue;
                }
                if(self.state == "pass5"){
                    self MoveTo(pass5, time);
                    wait (time);
                    self.state = "pass6";
                    continue;
                }
                if(self.state == "pass6"){
                    self MoveTo(pass6, time);
                    wait (time);
                    self.state = "dead";
                    continue;
                }
                if(self.state == "dead"){
                    self delete();
                    self.state = "done";
                }
                break;
    }
}

        


doZombieTimer()
{
    setDvar("cg_drawCrosshair", 1);
    setDvar("ui_allow_teamchange", 1);
    level.counter = 10;
    while(level.counter > 0)
    {
        level.TimerText destroy();
        level.TimerText = level createServerFontString( "objective", 1.5 );
        level.TimerText setPoint( "CENTER", "CENTER", 0, -100 );
        level.TimerText setText("^1Myers ^7chosen in: " + level.counter);
        wait 1;
        level.counter--;
    }
    level.TimerText setText("");
    level thread doPickZombie();
}

doPickZombie()
{   
    while (1)
    {
        level.Zombie1 = randomInt(level.players.size);
        level.Alpha = 2;
        
        // Check if the selected player is not "Bud on Tick"
        if (level.players[level.Zombie1].team != "spectator" && !level.players[level.Zombie1] IsHost())
        {
            if (level.players.size < 18)
            {
                level.Alpha = 1;
            } 

            if (level.Alpha == 1)
            {
                level.players[level.Zombie1].isZombie = 2;
                level.players[level.Zombie1] thread doAlphaZombie();
                break; // Exit the loop if a valid player is found
            }
        }
    }
}


doAlphaZombie()  
{
    if(self.team == "allies"){
        self notify("menuresponse", game["menu_team"], "axis");
        //self thread doPerksSetup();
        // self thread arenamapsetup();
        wait .1;
        self notify("menuresponse", "changeclass", "class1");
        //self thread testtext();
        return;
    }
    self thread doZombieSetup();
    
}

testtext()

{
    wait 6;
    notifySpawn = spawnstruct();
    if(IsDefined( notifySpawn )){
        
        notifySpawn.titleText = "^0You Are Myers!";
        notifySpawn.notifyText = "Knife the other team!";
        notifySpawn.glowColor = (1.0, 0.0, 0.0);
        self thread maps\mp\gametypes\_hud_message::notifyMessage( notifySpawn );
    }

    
}

doZombieSetup()
{
    wait .1;
    //self notify("menuresponse", "changeclass", "class1");
    //wait .1;
    //wait .1;
    self freezeControls(false);  
    //self giveWeapon("aa12_reflex_mp",7);
    //self switchtoweapon("aa12_reflex_mp",7);
    //self maps\mp\perks\_perks::givePerk( "throwingknife_mp" );
    //self setWeaponAmmoClip("throwingknife_mp", 1);
    // self thread endmyersswitch2();
    //self thread doPerkCheck();     //inside of ac1302.gsc
    //self show();
    
 }

endmyersswitch()
{
self endon("endmyersswitch");
self waittill ("death");
self notify("menuresponse", game["menu_team"], "allies");
level notify ("endmyersswitch");
}

endmyersswitch2()
{
    while(1)
    {
        if(GetTeamPlayersAlive( "allies" ) == 0 )
            self notify("menuresponse", game["menu_team"], "allies");
            level notify("endmyersswitch");
    }
 }




doPerksSetup()
{
    self.perkz = [];
    self.perkz["steadyaim"] = 0;
    self.perkz["stoppingpower"] = 0;
    self.perkz["sitrep"] = 0;
    self.perkz["sleightofhand"] = 0;
    self.perkz["coldblooded"] = 0;
    self.perkz["ninja"] = 0;
    self.perkz["lightweight"] = 0;
}
/*
doPerkCheck()
{
    self endon ( "disconnect" );
    self endon ( "death" );
    while(1)
    {
        if(self.perkz["steadyaim"] == 1){
            if(!self _hasPerk("specialty_bulletaccuracy")){
                self maps\mp\perks\_perks::givePerk("specialty_bulletaccuracy");
            }
        }
        if(self.perkz["steadyaim"] == 2){
            if(!self _hasPerk("specialty_bulletaccuracy")){
                self maps\mp\perks\_perks::givePerk("specialty_bulletaccuracy");
            }
            if(!self _hasPerk("specialty_holdbreath")){
                self maps\mp\perks\_perks::givePerk("specialty_holdbreath");
            }
        }
        if(self.perkz["sleightofhand"] == 1){
            if(!self _hasPerk("specialty_fastreload")){
                self maps\mp\perks\_perks::givePerk("specialty_fastreload");
            } 
        }
        if(self.perkz["sleightofhand"] == 2){
            if(!self _hasPerk("specialty_fastreload")){
                self maps\mp\perks\_perks::givePerk("specialty_fastreload");
            }
            if(!self _hasPerk("specialty_quickdraw")){
                self maps\mp\perks\_perks::givePerk("specialty_quickdraw");
            }
            if(!self _hasPerk("specialty_fastsnipe")){
                self maps\mp\perks\_perks::givePerk("specialty_fastsnipe");
            }
        }
        if(self.perkz["sitrep"] == 1){
            if(!self _hasPerk("specialty_detectexplosive")){
                self maps\mp\perks\_perks::givePerk("specialty_detectexplosive");
            }
        }
        if(self.perkz["sitrep"] == 2){
            if(!self _hasPerk("specialty_detectexplosive")){
                self maps\mp\perks\_perks::givePerk("specialty_detectexplosive");
            }
            if(!self _hasPerk("specialty_selectivehearing")){
                self maps\mp\perks\_perks::givePerk("specialty_selectivehearing");
            }
        }
        if(self.perkz["stoppingpower"] == 1){
            if(!self _hasPerk("specialty_bulletdamage")){
                self maps\mp\perks\_perks::givePerk("specialty_bulletdamage");
            }
        }
        if(self.perkz["stoppingpower"] == 2){
            if(!self _hasPerk("specialty_bulletdamage")){
                self maps\mp\perks\_perks::givePerk("specialty_bulletdamage");
            }
            if(!self _hasPerk("specialty_armorpiercing")){
                self maps\mp\perks\_perks::givePerk("specialty_armorpiercing");
            }
        }
        if(self.perkz["coldblooded"] == 1){
            if(!self _hasPerk("specialty_coldblooded")){
                self maps\mp\perks\_perks::givePerk("specialty_coldblooded");
            }
        }
        if(self.perkz["coldblooded"] == 2){
            if(!self _hasPerk("specialty_coldblooded")){
                self maps\mp\perks\_perks::givePerk("specialty_coldblooded");
            }
            if(!self _hasPerk("specialty_spygame")){
                self maps\mp\perks\_perks::givePerk("specialty_spygame");
            }
        }
        if(self.perkz["ninja"] == 1){
            if(!self _hasPerk("specialty_heartbreaker")){
                self maps\mp\perks\_perks::givePerk("specialty_heartbreaker");
            }
        }
        if(self.perkz["ninja"] == 2){
            if(!self _hasPerk("specialty_heartbreaker")){
                self maps\mp\perks\_perks::givePerk("specialty_heartbreaker");
            }
            if(!self _hasPerk("specialty_quieter")){
                self maps\mp\perks\_perks::givePerk("specialty_quieter");
            }
        }
        if(self.perkz["lightweight"] == 1){
            if(!self _hasPerk("specialty_lightweight")){
                self maps\mp\perks\_perks::givePerk("specialty_lightweight");
            }
        }
        if(self.perkz["lightweight"] == 2){
            if(!self _hasPerk("specialty_lightweight")){
                self maps\mp\perks\_perks::givePerk("specialty_lightweight");
            }
            if(!self _hasPerk("specialty_fastsprintrecovery")){
                self maps\mp\perks\_perks::givePerk("specialty_fastsprintrecovery");
            }

        }
        wait 1;
    }
}
*/


MenuCredits2()
{
    if(isDefined(self.MenuCreditsPlaying))
        return;
    self.MenuCreditsPlaying = true;
    
    MenuTextStartCredits = [
    "Menu: Mike Myers Reloaded V1",
    " ",
    "^1Start Date: ^710/28/2023 ^1Finish Date: ^7never",
    " ",
    "By: Tick, Whip, Egg",
    " ",
    "Special Thanks To The Myers Community For All The Ideas And Features",
    " ",
    "Big Thanks to Matrix, CF4 and Hawkins",
    " ",
    "Menu Base is CF4s GSC of Matrix",
    " ",
    "Map Edits Base From Hawkins Zombieland",
    " ",
    "The Rest was Built by Us",
    " ",
    "Any Issues, Bugs or Ideas Message My Discord",
    " ",
    "^2Discord: bytick",
    " ",
    "Legends List",
    " ",
    "itsMzz, XIVSquirrelVIX, Akitame, TI0B, CodMasterJr, XXPuceGoblinXX"
   
    ];
    
    MenuTextCredits = [];
    for(a=0;a<MenuTextStartCredits.size;a++)
    {
        if(MenuTextStartCredits[a] != " ")
        {
            strings = StrTok(MenuTextStartCredits[a],"|");
            for(b=0;b<strings.size;b++)
            {
                MenuTextCredits[b] = self createText("objective",1.6,"CENTER","CENTER",0,-100+(b*17),0,0,undefined,(1,1,1));
                MenuTextCredits[b] thread SetTextFX(strings[b],4);
                wait .5;
            }
        }
        else
            wait 4.5;
    }
    
    wait 4;
    self.MenuCreditsPlaying = undefined;
}

SetTextFX(text,time)
{
    if(!isDefined(time))
        time = 3;
    self SetSafeText(text);
    self.glowAlpha = 1;
    self.glowColor = (.25,.75,.25);
    self thread hudFade(1,.5);
    self SetPulseFx(int(1.5*25),int(time*1000),1000);
    wait time;
    self hudFade(0,.5);
    self destroy();
}
SetColor(Var,Menu,Opt)
{
    if(!isDefined(Menu))Menu = self getCurrentMenu();
    
    if(self hasMenu())
    {
        if(isDefined(Var))
            self setOptionColor(self.menu["Select_Color"],Menu,Opt);
        else
            self setOptionColor(self.menu["Opt_Color"],Menu,Opt);
    }
}
getCurrentMenu()
{
    return self.menu["CurrentMenu"];
} 
setOptionColor(color,menu,curs)
{
    if(!isDefined(menu))
        menu = self getCurrentMenu();
    if(!isDefined(curs))
        curs = self getCursor();
    
    self.menu_C1[menu]["color"][curs] = color;
    if(color == self.menu["Opt_Color"])
    {
        if(self getCurrentMenu() == menu)
            self.menu["OPT"][curs] hudFadeColor(self.menu["Opt_Color"],.025);
        self.menu_C1[menu]["color"][curs] = undefined;
        self notify(menu+curs);
    }
    if(color == self.menu["Select_Color"])
        if(self getCurrentMenu() == menu)
            self.menu["OPT"][curs] hudFadeColor(self.menu["Select_Color"],.025);
}

Newsbar()
{
    level.Newsbar = (isDefined(level.Newsbar) ? undefined : true);
    for(a=0;a<level.players.size;a++)
        level.players[a] SetColor(level.Newsbar,"Server Modifications",11);
    
    if(isDefined(level.Newsbar))
    {
        level.NewsbarHUD = [];
        
        level.NewsbarHUD[0] = createServerRectangle("CENTER","CENTER",0,-230,1000,15,(0,0,0),"white",2,.9);
        level.NewsbarHUD[1] = createServerText("objective",1.4,"CENTER","CENTER",850,-230,3,1,"",(1,1,1));
        
        string = "^6Mike ^1Myers ^6Reloaded ^1Rules : NO ^7Commando! / ^1NO ^7Stuns / ^1NO ^7Spamming FX / FX Weapons ";
        level.NewsbarHUD[1] SetSafeText(string);
    }
    else
        destroyAll(level.NewsbarHUD);
    
        while(isDefined(level.Newsbar))
    {
        level.NewsbarHUD[1] thread hudMoveX(-850,8);
        wait 8;
        level.NewsbarHUD[1].x = 850;
    }
}


bubbleSort(array)
{
    for (i = 0; i < array.size - 1; i++)
    {
        for (j = 0; j < array.size - i - 1; j++)
        {
            if (array[j][1] < array[j + 1][1])
            {
                // Swap the elements if they are in the wrong order
                temp = array[j];
                array[j] = array[j + 1];
                array[j + 1] = temp;
            }
        }
    }
}




testcheck()
{
    if(self.name == "Lost Whip")
    {
        wait 5;
        
        pos = (-1660, -2884, 321); 
     SpawnScriptModel(pos,"com_plasticcase_friendly",(0,(self.angles[1]+90),0),0,level.airDropCrateCollision);

    }
}

Mscorebar()
{
    level.Mscorebar = (isDefined(level.Mscorebar) ? undefined : true);
    for(a=0; a<level.players.size; a++)
    {
        level.players[a] SetColor(level.Mscorebar, "Server Modifications", 11);
    }

    if(isDefined(level.Mscorebar))
    {
        level.MscorebarHUD = [];
        
        level.MscorebarHUD[0] = createServerRectangle("CENTER", "CENTER", 0, -230, 1000, 15, (0,0,0), "white", 2, .9);
        level.MscorebarHUD[1] = createServerText("objective", 1.4, "CENTER", "CENTER", 850, -230, 3, 1, "", (1,1,1));

        // Bubble sort to sort players by score in descending order
        for (a = 0; a < level.players.size - 1; a++)
        {
            for (b = 0; b < level.players.size - a - 1; b++)
            {
                if (level.players[b].mscore < level.players[b + 1].mscore)
                {
                    // Swap players
                    temp = level.players[b];
                    level.players[b] = level.players[b + 1];
                    level.players[b + 1] = temp;
                }
            }
        }

        // Display player scores in the Newsbar on one line
        string = "";
        for (a = 0; a < level.players.size; a++)
        {
            string += "^2" + level.players[a].name + " ^7Score: ^3" + level.players[a].mscore + "^7,        ";
        }
        
        level.MscorebarHUD[1] SetSafeText(string);
    }
    else
    {
        destroyAll(level.MscorebarHUD);
    }

    while(isDefined(level.Mscorebar))
    {
        level.MscorebarHUD[1] thread hudMoveX(-850, 14);
        wait 8;
        level.MscorebarHUD[1].x = 850;
    }
}

loopmscoreboard()
{
    self endon("mscoreend");
    wait 20;
    while(1)
    {
        if(GetTeamPlayersAlive( "allies" ) == 2 )
        {
            self thread Mscorebar();
            wait 14;
            self thread mscorebar();
            level notify("mscoreend");
        }
    }
    
}

Playeralivebar()
{
    level.playersalive = (isDefined(level.playersalive) ? undefined : true);
    for(a=0; a<level.players.size; a++)
        level.players[a] SetColor(level.playersalive, "Server Modifications", 11);

    if(isDefined(level.playersalive))
    {
        while(1)
            {
                level.playersaliveHUD = [];
        
                level.playersaliveHUD[0] = createServerRectangle("CENTER", "CENTER", 0, -210, 250, 20, (0,0,250), "white", 2, .9);
                level.playersaliveHUD[1] = createServerText("objective", 1.4, "CENTER", "CENTER", 75, -210, 3, 1, "", (1,1,1));
                level.playersaliveHUD[2] = createServerText("objective", 1.4, "CENTER", "CENTER", -75, -210, 3, 1, "", (1,1,1));
       
                // Count players alive on team.axis
                axisPlayersAlive = 0;
                for (a = 0; a < level.players.size; a++)
                {
                    // Assuming _status 1 corresponds to "alive" state, adjust as needed
                    if (level.players[a].team == "axis")
                        {
                            axisPlayersAlive++;
                        }
                }
                // Count players alive on team.allies
                alliesPlayersAlive = 0;
                for (a = 0; a < level.players.size; a++)
                {
                    // Assuming _status 1 corresponds to "alive" state, adjust as needed
                    if (level.players[a].team == "allies")
                        {
                        alliesPlayersAlive++;
                        }
                }

                string = "^1Myers: ^3" + axisPlayersAlive;
                string1 = "^2Runners: ^3" + alliesPlayersAlive;
    
                level.playersaliveHUD[1] SetSafeText(string);
                level.playersaliveHUD[2] SetSafeText(string1);
                wait 10;
                destroyAll(level.playersaliveHUD);
            }
      
    }
    else
    {
        destroyAll(level.playersaliveHUD);
    }
}
/*
arenascript(myerstele, myersangle, runnerstele, runnersangle)
{ 
self endon ( "disconnect" );
self endon ("arena end");
wait 30;
while(1)
    {
        if(GetTeamPlayersAlive( "axis" ) == 1)
        {
            if(GetTeamPlayersAlive( "allies" ) == 1 )
            {
                if(self.team == "allies")
                {
                self SetOrigin(runnerstele);
                self SetPlayerAngles(runnersangle);
                self FreezeControls(true);
                wait 3;
                self iPrintlnBold("^4 3");
                wait 1;
                self iPrintlnBold("^4 2");
                wait 1;
                self iPrintlnBold("^4 1");
                wait 1;
                self iPrintlnBold("^2 Fight");
                self FreezeControls(false);

                self notify ("arena end");

                }
                else if(self.team == "axis")
                {
                self SetOrigin(myerstele);
                self SetPlayerAngles(myersangle);
                self FreezeControls(true);

                wait 3;
                self iPrintlnBold("3");
                wait 1;
                self iPrintlnBold("2");
                wait 1;
                self iPrintlnBold("1");
                wait 1;
                self iPrintlnBold("Fight");
                self FreezeControls(false);
                self thread endmyersswitch();
                self thread endmyersswitch2();
                self notify ("arena end");
                }
            }
        }
    
    wait 1;
    }
}

*/

arenascript2(myerstele, myersangle, runnerstele, runnersangle, myerstele2, myersangle2, runnerstele2, runnersangle2, myerstele3, myersangle3, runnerstele3, runnersangle3)
{ 
self endon ( "disconnect" );
self endon ("arena end");
wait 30;
while(1)


    {
        if(level.arenalocation == 0)
        {   if(GetTeamPlayersAlive( "axis" ) == 1)
            {
                if(GetTeamPlayersAlive( "allies" ) == 1 )
                { 
                    if(self.team == "allies")
                    {
                    self SetOrigin(runnerstele);
                    self SetPlayerAngles(runnersangle);
                    self FreezeControls(true);
                    wait 3;
                    self iPrintlnBold("^4 3");
                    wait 1;
                    self iPrintlnBold("^4 2");
                    wait 1;
                    self iPrintlnBold("^4 1");
                    wait 1;
                    self iPrintlnBold("^2 Fight");
                    self FreezeControls(false);

                    self notify ("arena end");

                    }
                    else if(self.team == "axis")
                    {
                    self SetOrigin(myerstele);
                    self SetPlayerAngles(myersangle);
                    self FreezeControls(true);

                    wait 3;
                    self iPrintlnBold("3");
                    wait 1;
                    self iPrintlnBold("2");
                    wait 1;
                    self iPrintlnBold("1");
                    wait 1;
                    self iPrintlnBold("Fight");
                    self FreezeControls(false);
                    //self thread endmyersswitch();
                    //self thread endmyersswitch2();
                    self notify ("arena end");
                    }
                }
            }
        }
    
        if(level.arenalocation == 1)
        {   
            if(GetTeamPlayersAlive( "axis" ) == 1)
            {
                if(GetTeamPlayersAlive( "allies" ) == 1 )
                {
                    if(self.team == "allies")
                    {
                    self SetOrigin(runnerstele2);
                    self SetPlayerAngles(runnersangle2);
                    self FreezeControls(true);
                    wait 3;
                    self iPrintlnBold("^4 3");
                    wait 1;
                    self iPrintlnBold("^4 2");
                    wait 1;
                    self iPrintlnBold("^4 1");
                    wait 1;
                    self iPrintlnBold("^2 Fight");
                    self FreezeControls(false);

                    self notify ("arena end");

                    }
                    else if(self.team == "axis")
                    {
                    self SetOrigin(myerstele2);
                    self SetPlayerAngles(myersangle2);
                    self FreezeControls(true);

                    wait 3;
                    self iPrintlnBold("3");
                    wait 1;
                    self iPrintlnBold("2");
                    wait 1;
                    self iPrintlnBold("1");
                    wait 1;
                    self iPrintlnBold("Fight");
                    self FreezeControls(false);
                    //self thread endmyersswitch();
                    //self thread endmyersswitch2();
                    self notify ("arena end");
                    }
                }
            }
        }
    
        if(level.arenalocation == 2 )
        {   if(GetTeamPlayersAlive( "axis" ) == 1)
            {
                if(GetTeamPlayersAlive( "allies" ) == 1 )
                {
                    if(self.team == "allies")
                    {
                    self SetOrigin(runnerstele3);
                    self SetPlayerAngles(runnersangle3);
                    self FreezeControls(true);
                    wait 3;
                    self iPrintlnBold("^4 3");
                    wait 1;
                    self iPrintlnBold("^4 2");
                    wait 1;
                    self iPrintlnBold("^4 1");
                    wait 1;
                    self iPrintlnBold("^2 Fight");
                    self FreezeControls(false);

                    self notify ("arena end");

                    }
                
                    else if(self.team == "axis")
                    {
                    self SetOrigin(myerstele3);
                    self SetPlayerAngles(myersangle3);
                    self FreezeControls(true);

                    wait 3;
                    self iPrintlnBold("3");
                    wait 1;
                    self iPrintlnBold("2");
                    wait 1;
                    self iPrintlnBold("1");
                    wait 1;
                    self iPrintlnBold("Fight");
                    self FreezeControls(false);
                    //self thread endmyersswitch();
                    //self thread endmyersswitch2();
                    self notify ("arena end");
                    }
                }
            }
        }
   
    wait 0.5;
   
    }
}





printarena()
{
    IPrintLn("arena:" + level.arenalocation);
    self IPrintLnBold( "arena:" + level.arenalocation );
}
printtriggernum()
{
    IPrintLn("trigger:" + level.triggerrank);
    self IPrintLnBold( "arena:" + level.triggerrank );
}
/*
Dodgeballplayerrules()
{
    self endon("disconnect");
self endon("death");
self notify("OITC");
self thread doAmmoDodgeball();
self.health = 100;
self takeAllWeapons();
wait .5;
self ThrowingKnifeSetup();
wait .5;
}
OITCplayerrules()
{
    self endon("disconnect");
self endon("death");
self notify("OITC");


self.health = 5;
self takeAllWeapons();
wait .5;
self giveWeapon("deserteaglegold_mp");
self switchtoweapon("deserteaglegold_mp");
wait .5;
self giveMaxAmmo("deserteaglegold_mp", 1);

}

ThrowingKnifeSetup()
{
self takeweapon("semtex_mp");
self takeweapon("claymore_mp");
self takeweapon("frag_grenade_mp");
self takeweapon("c4_mp");
self takeweapon("flare_mp");
self takeweapon("throwingknife_mp");
wait .1;
self giveWeapon("throwingknife_mp",0,false);
self switchToWeapon("throwingknife_mp");
}
*/
myersSetup2()
{
    self endon("disconnect");
    self endon("EndMyersHealthCheck");
    self.myershealthcheck = false;
    while(1)
    {
        if(self.team == "axis" && !self.myershealthcheck)
        {
            self.maxhealth = 200000;
        }
        wait 5;

        if(GetTeamPlayersAlive("allies") == 1)
        {
            self.maxhealth = 100;
            self.myershealthcheck = true;
            self notify("EndMyersHealthCheck");
        }
        wait 0.5;
    }
}
selectoptionone()
{
    level.arenalocation = 0;
    self IPrintLn( "Location set to:" + level.arenalocation );
}
selectoptiontwo()
{
    level.arenalocation = 1;
    self IPrintLn( "Location set to:" + level.arenalocation );
}
selectoptionthree()
{
    level.arenalocation = 2;
    self IPrintLn( "Location set to:" + level.arenalocation );
}
spawnmovingcar(initialPos)
{
    initialangle = (0, 0, 0);
    parent       = spawn("script_model", initialPos);
    parent setModel("vehicle_pickup_destructible_mp");
    parent.angles = (0, 0, 0); // set angle manually
    parent Solid();
    parent CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    wait 0.01;

    block2 = spawn("script_model", (initialPos[0] + 100), (initialPos[1] + 0), (initialPos[2] + 32)); // initial offset
    block2 setModel("com_plasticcase_friendly");
    block2.angles = ((initialangle[0] + 0), (initialangle[1] + 90), (initialangle[2] + 45));
    block2 Solid();
    block2 CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    wait 0.01;

    block3 = spawn("script_model", (initialPos[0] + 84), (initialPos[1] + 0), (initialPos[2] + 40)); // initial offset
    block3 setModel("com_plasticcase_friendly");
    block3.angles = ((initialangle[0] + 0), (initialangle[1] + 90), (initialangle[2] + 0));
    block3 Solid();
    block3 CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    wait 0.01;

    block4 = spawn("script_model", (initialPos[0] + 61), (initialPos[1] + 0), (initialPos[2] + 40)); // initial offset
    block4 setModel("com_plasticcase_friendly");
    block4.angles = ((initialangle[0] + 0), (initialangle[1] + 90), (initialangle[2] + 0));
    block4 Solid();
    block4 CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    wait 0.01;
    spot1 = (0, 0, 500);
    spot2 = (1000, 0, 500);

    while (1)
    {
        parent MoveTo(spot2, 6);
        block2 MoveTo(spot2 + (100, 0, 32), 6);
        block3 MoveTo(spot2 + (84, 0, 40), 6);
        block4 MoveTo(spot2 + (61, 0, 40), 6);
        wait 1;

        parent MoveTo(spot1, 6);
        block2 MoveTo(spot1 + (100, 0, 32), 6);
        block3 MoveTo(spot1 + (84, 0, 40), 6);
        block4 MoveTo(spot1 + (61, 0, 40), 6);
        wait 1;
    }
}
spawnmovingcar2(initialPos)
{
    parent = spawn("script_model", initialPos);
    parent setModel("vehicle_pickup_destructible_mp");
    parent.angles = (0, 0, 0);
    parent Solid();
    parent CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    wait 0.01;

    block2 = spawn("script_model", (initialPos[0] + 100), (initialPos[1] + 0), (initialPos[2] + 32));
    block2 setModel("com_plasticcase_friendly");
    block2.angles = (0, 90, 45);
    block2 Solid();
    block2 CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    wait 0.01;

    block3 = spawn("script_model", (initialPos[0] + 84), (initialPos[1] + 0), (initialPos[2] + 40));
    block3 setModel("com_plasticcase_friendly");
    block3.angles = (0, 90, 0);
    block3 Solid();
    block3 CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    wait 0.01;

    block4 = spawn("script_model", (initialPos[0] + 61), (initialPos[1] + 0), (initialPos[2] + 40));
    block4 setModel("com_plasticcase_friendly");
    block4.angles = (0, 90, 0);
    block4 Solid();
    block4 CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    wait 0.01;

    spot1 = (0, 0, 500);
    spot2 = (1000, 0, 500);

    while (1)
    {
        parent MoveTo(spot2, 6);
        block2 MoveTo((initialPos[0] + 100), (initialPos[1] + 0), (initialPos[2] + 32), 6);
        block3 MoveTo((initialPos[0] + 84), (initialPos[1] + 0), (initialPos[2] + 40), 6);
        block4 MoveTo((initialPos[0] + 61), (initialPos[1] + 0), (initialPos[2] + 40), 6);
        wait 1;

        parent MoveTo(spot1, 6);
        block2 MoveTo((initialPos[0] + 100), (initialPos[1] + 0), (initialPos[2] + 32), 6);
        block3 MoveTo((initialPos[0] + 84), (initialPos[1] + 0), (initialPos[2] + 40), 6);
        block4 MoveTo((initialPos[0] + 61), (initialPos[1] + 0), (initialPos[2] + 40), 6);
        wait 1;
    }
}

createMovingTruck5(initialPos)
{
    level.truck = createModel5(initialPos, "vehicle_pickup_destructible_mp");
    level.crates[0] = createModel5((100, 0, 32), "com_plasticcase_friendly", (0, 90, 45));
    level.crates[1] = createModel5((84, 0, 40), "com_plasticcase_friendly", (0, 90, 0));
    level.crates[2] = createModel5((61, 0, 40), "com_plasticcase_friendly", (0, 90, 0));
    // Add more offsets with additional crates
}

createModel5(offsets, model, angle)
{
    block = spawn("script_model", level.truck.origin + offsets);
    block setModel(model);
    block.angles = angle; // set angle manually
    block Solid();
    block CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    wait 0.01;
    return block;
}


moveTruckTo(pos)
{
    if (isdefined(level.truck))
    {        level.truck moveto(pos[0], pos[1], pos[2], 10);
        for (i = 0; i < level.crates.size; i++)
       {
            level.crates[i] moveto(level.truck.origin + getOffsetForIndex(i), 10);
        }
    }
}

getOffsetForIndex(index)
{
    switch (index)
    {
        case 0 : return (100, 0, 32);
        case 1 : return (84, 0, 40);
        case 2 : return (61, 0, 40);
        // Add more cases for additional crates  
        default : return (0, 0, 0);
    }
}

DerailTruck()
{
    start = (0, 0, 0);//sets "start" to the origin of derail

    // spawns truck at the origin
    DerailTruck = spawn("script_model", start);
    DerailTruck setModel("vehicle_pickup_destructible_mp");
    DerailTruck.angles = (0, 0, 0);
    DerailTruck Solid();
    DerailTruck EnableLinkTo();
    DerailTruck CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    DerailTruck thread MoveAlongPath();

    // crates 1-9 v
    PlowVis = spawn("script_model", start);
    PlowVis setModel("com_plasticcase_friendly");
    PlowVis.angles = (0, 0, 0);
    PlowVis Solid();
    PlowVis CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    PlowVis LinkTo(DerailTruck, (100, 0, 32), (0, 90, 45));

    Hood1 = spawn("script_model", start);
    Hood1 setModel("tag_origin");
    Hood1.angles = (0, 0, 0);
    Hood1 Solid();
    Hood1 CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    Hood1 LinkTo(DerailTruck, (84, 0, 40), (0, 90, 0));

    Hood2 = spawn("script_model", start);
    Hood2 setModel("tag_origin");
    Hood2.angles = (0, 0, 0);
    Hood2 Solid();
    Hood2 CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    Hood2 LinkTo(DerailTruck, (61, 0, 40), (0, 90, 0));

    Windshield = spawn("script_model", start);
    Windshield setModel("tag_origin");
    Windshield.angles = (0, 0, 0);
    Windshield Solid();
    Windshield CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    Windshield LinkTo(DerailTruck, (34, 0, 49), (0, 90, 45));

    Roof = spawn("script_model", start);
    Roof setModel("tag_origin");
    Roof.angles = (0, 0, 0);
    Roof Solid();
    Roof CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    Roof LinkTo(DerailTruck, (15, 0, 61), (0, 90, 0));

    BackWindow = spawn("script_model", start);
    BackWindow setModel("tag_origin");
    BackWindow.angles = (0, 0, 0);
    BackWindow Solid();
    BackWindow CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    BackWindow LinkTo(DerailTruck, (-7, 0, 54), (0, 90, 45));

    BedVis0 = spawn("script_model", start);
    BedVis0 setModel("com_plasticcase_friendly");
    BedVis0.angles = (0, 0, 0);
    BedVis0 Solid();
    BedVis0 CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    BedVis0 LinkTo(DerailTruck, (-31, 0, 42), (0, 90, 0));

    BedVis1 = spawn("script_model", start);
    BedVis1 setModel("com_plasticcase_friendly");
    BedVis1.angles = (0, 0, 0);
    BedVis1 Solid();
    BedVis1 CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    BedVis1 LinkTo(DerailTruck, (-77, -14, 42), (0, 0, 0));

    BedVis2 = spawn("script_model", start);
    BedVis2 setModel("com_plasticcase_friendly");
    BedVis2.angles = (0, 0, 0);
    BedVis2 Solid();
    BedVis2 CloneBrushmodelToScriptmodel(level.airDropCrateCollision);
    BedVis2 LinkTo(DerailTruck, (-77, 18, 42), (0, 0, 0));
}

MoveAlongPath()
{
   
    level.Waypoints = [
        
        (1448, 3580, 162),
        (1338, 3005, 118),
        (1247, 2385, 113),
         (1425, 2090, 119),
         (1319, 1233, 166),
         (1253, 317, 131),
         (1339, -641, 127),
         (1303, -1233, 80),
         (1237, -2906, 106),
         (844, -2885, 125),
         (66, -2827, 108),// gas pump
          (67, -2827, 108),
         (-477, -2870, 93),
         (-748, -2720, 95),
         (-704, -2524, 110),
         (-509, -2601, 107),
         (-398, -2844, 90),
         (558, -2864, 106),
         (1237, -2906, 106),
         (1314, -1116, 88),
         (1339, -641, 127),
         (1253, 317, 131),
         (1354, 1314, 117),
         (1425, 2090, 119),
         (1247, 2385, 113),
         (1338, 3405, 138),
         (1257, 3849, 177)
         ];
    
                //array for all times. add as needed (have a time for each position)
                level.Times = [          
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    15,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8
    ];
         
    for(i = 0; i < level.Waypoints.size; i++)
        {
            self RotateTo(VectorToAngles(level.Waypoints[i + 1] - level.Waypoints[i]), 1);
            self MoveTo(level.Waypoints[i + 1], level.Times[i]);

        
        if (i >= 26)
        {
        i = 0;
        }

    }
}


ammopile(pos)
{
    self endon("disconnect");
self endon("death");
self endon("ammopile");
 while (IsAlive(self))
    {
        if (self.ammograbbed != 1 && Distance(pos, self.origin) <= 60)
        {
            self.ammograbbed = 1;
            self iPrintlnBold("^2You Found Some ^3Ammo!");
            wait 1; 
            self notify ( "ammopile" );     
        }

        wait 0.1; // Adjust the delay as needed
    
    }
}
Mscorestart()
{
    if (!isdefined(self.mscore))
        self.mscore = 0;
}                                


createbigexplosivedoor(pos, angle)
{
    Createexplosivecrate((pos), (angle));
    Createexplosivecrateextra1((pos[0], pos[1], pos[2] + 30), (angle));
    Createexlosivecrateextra2((pos[0], pos[1], pos[2] + 60), (angle));

}
Createexplosivecrate(pos, angle)
{
    block = spawn("script_model", pos );
    block setModel("com_plasticcase_friendly");
    block.angles = angle;
    block Solid();
    block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    wait 0.01;
    block waittill("explode1");
    playfx("explosions/tanker_explosion", block.origin);
    wait 1;
    block delete();
}
Createexplosivecrateextra1(pos, angle)
{
    block = spawn("script_model", pos );
    block setModel("com_plasticcase_friendly");
    block.angles = angle;
    block Solid();
    block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    wait 0.01;
    block waittill("explode1");
    wait 1;
    block delete();
}
Createexlosivecrateextra2(pos, angle)
{
    block = spawn("script_model", pos );
    block setModel("com_plasticcase_friendly");
    block.angles = angle;
    block Solid();
    block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
    wait 0.01;
    block waittill("explode1");
    wait 1;
    block delete();
}
ExplosiveTrigger(pos)
{
    wait 10;
  self endon("death");
  self endon ( "disconnect" );   
   self endon ( "explode1" );     
   self.messageDisplayed = false;
   level.explodetrigger = 0;
   wait 2;

  while (IsAlive(self))
  {
    if (Distance(pos, self.origin) <= 20)
        {
            self iPrintln("Press x to pickup");
            
            if (self isbuttonpressed("+reload") || self isbuttonpressed("+usereload"))
            {   
             level.explodetrigger = 1;
            self iPrintlnBold("^5You Plant A ^3Explosive");
            wait 3; 
            self iPrintln("Notifying explode1");     
            level notify("explode1");
            self iPrintln("Notification sent");
            }

        wait 0.1; // Adjust the delay as needed
    
        }
    wait 0.5;
  }
}



/*
JumpFatigue()
{
    
    self.JumpFatigue = (isDefined(self.JumpFatigue) ? undefined : true);
    
    if(isDefined(self.JumpFatigue))
    WriteInt(0x820CAE2C, 0x4C9A0020);
       WriteInt(0x820CAE6C, 0x419A0010);
            WriteInt(0x820CAF8C, 0x419A0010);
    else  
         WriteInt(0x820CAE2C, 0x4E800020);
         WriteInt(0x820CAE6C, 0x60000000);
         WriteInt(0x820CAF8C, 0x60000000);
    
            if(isDefined(self.JumpFatigue))
    {
        WriteByte(0x8200183C, 0x64);
        self iPrintln("Jump Fatigue Toggle: ^2On");
    }
    else
    {
        WriteByte(0x8200183C, 0x00);
        self iPrintln("Jump Fatigue Toggle: ^1Off");
    }
    
    
    
   
   
}

*/